package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.dao.comun.UtilDAO;
import com.ejie.ab04b.model.ComunicacionApertura;
import com.ejie.ab04b.model.ComunicacionPrl;
import com.ejie.ab04b.model.DatosLocalizacion;
import com.ejie.ab04b.model.DatosNotificacion;
import com.ejie.ab04b.model.nora.Localidad;
import com.ejie.ab04b.model.nora.Municipio;
import com.ejie.ab04b.model.nora.Provincia;
import com.ejie.ab04b.util.Utilities;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * ComunicacionPrlDaoImpl generated by UDA, 23-feb-2017 13:09:26.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class ComunicacionPrlDaoImpl implements ComunicacionPrlDao {
	private JdbcTemplate jdbcTemplate;

	private static final String QUERY_SELECT = "SELECT t1.TIPOOS TIPOOS, t1.TEROS TEROS, t1.ANOOS ANOOS, t1.NUMOS NUMOS, t1.FECPRE FECPRE, t1.FECIER FECIER, t1.TERAPE TERAPE, t1.ANOAPE ANOAPE, t1.NUMAPE NUMAPE, t1.TIPDOC TIPDOC, t1.NUMDOC NUMDOC, t1.NOMEMP NOMEMP, t1.PAISEMP PAISEMP, t1.PRVEMP PRVEMP, t1.MUNEMP MUNEMP, t1.DMUNEMP DMUNEMP, t1.DIREMP DIREMP, t1.CPOEMP CPOEMP, t1.TLFEMP TLFEMP, t1.FAXEMP FAXEMP, t1.EMAEMP EMAEMP, t1.HTTPEMP HTTPEMP, t1.TRBTOT TRBTOT, t1.OBSERV OBSERV, t1.CODCTR CODCTR, t1.FECALT FECALT, t1.USUALT USUALT, t1.FECMOD FECMOD, t1.USUMOD USUMOD, t1.DESCEMP DESCEMP, t1.DOCCORRECTA DOCCORRECTA, t1.ESTADO ESTADO, t1.FORPRE FORPRE, t1.CNAEEMP CNAEEMP, t1.INDANX INDANX, t1.APDOANX APDOANX, t1.PRVCTR PRVCTR, t1.MUNCTR MUNCTR, t1.LOCCTR LOCCTR, t1.DIRCTR DIRCTR, t1.CPOCTR CPOCTR, t1.TIPMPR1 TIPMPR1, t1.NOMMPR1 NOMMPR1, t1.TIPMPR2 TIPMPR2, t1.NOMMPR2 NOMMPR2, t1.TOPSEG1 TOPSEG1, t1.TOPSEG2 TOPSEG2, t1.TOPHIG1 TOPHIG1, t1.TOPHIG2 TOPHIG2, t1.TOPERG1 TOPERG1, t1.TOPERG2 TOPERG2, t1.TOPVIG1 TOPVIG1, t1.TOPVIG2 TOPVIG2, t1.TIPRIE1 TIPRIE1, t1.NOMRIE1 NOMRIE1, t1.TIPRIE2 TIPRIE2, t1.NOMRIE2 NOMRIE2, t1.INDAUD INDAUD, t1.FECAUD FECAUD, t1.EMPAUD EMPAUD, t1.DESCCEN DESCCEN, t1.CODEMPAUD CODEMPAUD, t1.CODPREV1 CODPREV1, t1.CODPREV2 CODPREV2, t1.CNAEEMP93 CNAEEMP93, t1.CLASCTR CLASCTR, t1.DECLAR DECLAR, t1.CARDEC CARDEC, t1.FECEVR FECEVR, t1.DESRIE DESRIE, t1.DESACT DESACT, t1.NUEVA NUEVA, t1.MIGRADO MIGRADO, t1.FOLDER_ID FOLDERID, t1.COD_DATOS_NOTIF CODDATOSNOTIF, t1.USUARIOAPE USUARIOAPE, t1.USUARIOAPORT USUARIOAPORT, t1.USUARIOTRAM USUARIOTRAM,"
			+ "t1.NUMDOCREPRESENTANTE NUMDOCREPRESENTANTE, t1.NOMREPRESENTANTE NOMREPRESENTANTE, t1.TIPDOCREPRESENTANTE TIPDOCREPRESENTANTE ";

	private static final String QUERY_SELECT_DATOS_ETIQUETAS = " SELECT t1.TEROS TERAPE, t1.ANOOS ANOAPE, t1.NUMOS NUMAPE, t1.NOMEMP NOMEMP, t3.CALLE_067 CALLE, t3.CODPOSTAL_067 CP, "
			+ " t3.COD_MUNICIPIO_067 CODMUNI, d1.DS_O MUNIDESC, t3.PORTAL_067 PORTAL, t3.PISO_067 PISO, t3.PUERTA_067 PUERTA, t3.COD_LOCALIDAD_067 CODLOCALI, d2.DESCRIPCION LOCALIDESC, "
			+ " t3.COD_PROVINCIA_067 CODPROV, d3.DS_O PROVDESC";

	private static final String QUERY_FROM_DATOS_ETIQUETAS = " FROM VCOMUNICACION_PRL t1 LEFT JOIN AB0466T00 t2 ON t1.COD_DATOS_NOTIF= t2.COD_DATOS_NOTIF_066 LEFT JOIN AB0467T00 t3 ON t2.COD_LOCALIZACION_066 = t3.COD_LOCALIZACION_067 "
			+ " LEFT JOIN MUNICIPIO_NORA d1 ON d1.PROVINCIA_ID = t3.COD_PROVINCIA_067 AND d1.ID = t3.COD_MUNICIPIO_067 LEFT JOIN LOCALIDAD_NORA d2 ON d2.COD_LOCALIDAD = t3.COD_LOCALIDAD_067 LEFT JOIN PROVINCIA_NORA d3 ON d3.ID = t3.COD_PROVINCIA_067 "
			+ " where t2.CANALNOTIF_066=1 ";

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<ComunicacionPrl> rwMap = new RowMapper<ComunicacionPrl>() {
		public ComunicacionPrl mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			ComunicacionPrl comunicacionPrl = new ComunicacionPrl(
					resultSet.getString("TIPOOS"),
					resultSet.getString("TEROS"),
					resultSet.getString("ANOOS"),
					resultSet.getInt("NUMOS"),
					// resultSet.getDate("FECPRE")
					resultSet.getTimestamp("FECPRE"),
					resultSet.getDate("FECIER"), resultSet.getString("TERAPE"),
					resultSet.getString("ANOAPE"), resultSet.getInt("NUMAPE"),
					resultSet.getString("TIPDOC"),
					resultSet.getString("NUMDOC"),
					resultSet.getString("NOMEMP"),
					resultSet.getString("PAISEMP"),
					resultSet.getString("PRVEMP"),
					resultSet.getString("MUNEMP"),
					resultSet.getString("DMUNEMP"),
					resultSet.getString("DIREMP"),
					resultSet.getString("CPOEMP"),
					resultSet.getString("TLFEMP"),
					resultSet.getString("FAXEMP"),
					resultSet.getString("EMAEMP"),
					resultSet.getString("HTTPEMP"),
					resultSet.getBigDecimal("TRBTOT"),
					resultSet.getString("OBSERV"), resultSet.getInt("CODCTR"),
					resultSet.getDate("FECALT"), resultSet.getString("USUALT"),
					resultSet.getDate("FECMOD"), resultSet.getString("USUMOD"),
					resultSet.getString("DESCEMP"),
					resultSet.getString("DOCCORRECTA"),
					resultSet.getString("ESTADO"),
					resultSet.getString("FORPRE"),
					resultSet.getString("CNAEEMP"),
					resultSet.getString("INDANX"),
					resultSet.getString("APDOANX"),
					resultSet.getString("PRVCTR"),
					resultSet.getString("MUNCTR"),
					resultSet.getString("LOCCTR"),
					resultSet.getString("DIRCTR"),
					resultSet.getString("CPOCTR"),
					resultSet.getString("TIPMPR1"),
					resultSet.getString("NOMMPR1"),
					resultSet.getString("TIPMPR2"),
					resultSet.getString("NOMMPR2"),
					resultSet.getString("TOPSEG1"),
					resultSet.getString("TOPSEG2"),
					resultSet.getString("TOPHIG1"),
					resultSet.getString("TOPHIG2"),
					resultSet.getString("TOPERG1"),
					resultSet.getString("TOPERG2"),
					resultSet.getString("TOPVIG1"),
					resultSet.getString("TOPVIG2"),
					resultSet.getString("TIPRIE1"),
					resultSet.getString("NOMRIE1"),
					resultSet.getString("TIPRIE2"),
					resultSet.getString("NOMRIE2"),
					resultSet.getString("INDAUD"), resultSet.getDate("FECAUD"),
					resultSet.getString("EMPAUD"),
					resultSet.getString("DESCCEN"),
					resultSet.getString("CODEMPAUD"),
					resultSet.getString("CODPREV1"),
					resultSet.getString("CODPREV2"),
					resultSet.getString("CNAEEMP93"),
					resultSet.getString("CLASCTR"),
					resultSet.getString("DECLAR"),
					resultSet.getString("CARDEC"), resultSet.getDate("FECEVR"),
					resultSet.getString("DESRIE"),
					resultSet.getString("DESACT"),
					resultSet.getString("NUEVA"),
					resultSet.getString("MIGRADO"),
					resultSet.getString("FOLDERID"),
					resultSet.getString("CODDATOSNOTIF"),
					new DatosNotificacion(resultSet.getInt("CODDATOSNOTIF")),
					resultSet.getString("USUARIOAPE"),
					resultSet.getString("USUARIOAPORT"),
					resultSet.getString("USUARIOTRAM"),
					resultSet.getString("NUMDOCREPRESENTANTE"),
					resultSet.getString("NOMREPRESENTANTE"),
					resultSet.getString("TIPDOCREPRESENTANTE"));

			if (UtilDAO.hasColumn(resultSet, "NEXTTIPOOS")
					&& resultSet.getString("NEXTTIPOOS") != null
					&& resultSet.getString("NEXTTIPOOS").equals(
							resultSet.getString("TIPOOS"))
					&& UtilDAO.hasColumn(resultSet, "NEXTROW")) {
				comunicacionPrl.setNext(resultSet.getString("NEXTROW"));

			}
			if (UtilDAO.hasColumn(resultSet, "PREVIOUSTIPOOS")
					&& resultSet.getString("PREVIOUSTIPOOS") != null
					&& resultSet.getString("PREVIOUSTIPOOS").equals(
							resultSet.getString("TIPOOS"))
					&& UtilDAO.hasColumn(resultSet, "PREVIOUSROW")) {
				comunicacionPrl.setPrev(resultSet.getString("PREVIOUSROW"));

			}

			return comunicacionPrl;
		}
	};

	private RowMapper<ComunicacionPrl> rwMapPK = new RowMapper<ComunicacionPrl>() {
		public ComunicacionPrl mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new ComunicacionPrl(resultSet.getString("TIPOOS"),
					resultSet.getString("TEROS"), resultSet.getString("ANOOS"),
					resultSet.getInt("NUMOS"), resultSet.getDate("FECPRE"),
					resultSet.getDate("FECIER"), resultSet.getString("TERAPE"),
					resultSet.getString("ANOAPE"), resultSet.getInt("NUMAPE"),
					resultSet.getString("TIPDOC"),
					resultSet.getString("NUMDOC"),
					resultSet.getString("NOMEMP"),
					resultSet.getString("PAISEMP"),
					resultSet.getString("PRVEMP"),
					resultSet.getString("MUNEMP"),
					resultSet.getString("DMUNEMP"),
					resultSet.getString("DIREMP"),
					resultSet.getString("CPOEMP"),
					resultSet.getString("TLFEMP"),
					resultSet.getString("FAXEMP"),
					resultSet.getString("EMAEMP"),
					resultSet.getString("HTTPEMP"),
					resultSet.getBigDecimal("TRBTOT"),
					resultSet.getString("OBSERV"), resultSet.getInt("CODCTR"),
					resultSet.getDate("FECALT"), resultSet.getString("USUALT"),
					resultSet.getDate("FECMOD"), resultSet.getString("USUMOD"),
					resultSet.getString("DESCEMP"),
					resultSet.getString("DOCCORRECTA"),
					resultSet.getString("ESTADO"),
					resultSet.getString("FORPRE"),
					resultSet.getString("CNAEEMP"),
					resultSet.getString("INDANX"),
					resultSet.getString("APDOANX"),
					resultSet.getString("PRVCTR"),
					resultSet.getString("MUNCTR"),
					resultSet.getString("LOCCTR"),
					resultSet.getString("DIRCTR"),
					resultSet.getString("CPOCTR"),
					resultSet.getString("TIPMPR1"),
					resultSet.getString("NOMMPR1"),
					resultSet.getString("TIPMPR2"),
					resultSet.getString("NOMMPR2"),
					resultSet.getString("TOPSEG1"),
					resultSet.getString("TOPSEG2"),
					resultSet.getString("TOPHIG1"),
					resultSet.getString("TOPHIG2"),
					resultSet.getString("TOPERG1"),
					resultSet.getString("TOPERG2"),
					resultSet.getString("TOPVIG1"),
					resultSet.getString("TOPVIG2"),
					resultSet.getString("TIPRIE1"),
					resultSet.getString("NOMRIE1"),
					resultSet.getString("TIPRIE2"),
					resultSet.getString("NOMRIE2"),
					resultSet.getString("INDAUD"), resultSet.getDate("FECAUD"),
					resultSet.getString("EMPAUD"),
					resultSet.getString("DESCCEN"),
					resultSet.getString("CODEMPAUD"),
					resultSet.getString("CODPREV1"),
					resultSet.getString("CODPREV2"),
					resultSet.getString("CNAEEMP93"),
					resultSet.getString("CLASCTR"),
					resultSet.getString("DECLAR"),
					resultSet.getString("CARDEC"), resultSet.getDate("FECEVR"),
					resultSet.getString("DESRIE"),
					resultSet.getString("DESACT"),
					resultSet.getString("NUEVA"),
					resultSet.getString("MIGRADO"),
					resultSet.getString("FOLDERID"),
					resultSet.getString("CODDATOSNOTIF"),
					new DatosNotificacion(resultSet.getInt("CODDATOSNOTIF")),
					resultSet.getString("USUARIOAPE"),
					resultSet.getString("USUARIOAPORT"),
					resultSet.getString("USUARIOTRAM"),
					resultSet.getString("NUMDOCREPRESENTANTE"),
					resultSet.getString("NOMREPRESENTANTE"),
					resultSet.getString("TIPDOCREPRESENTANTE"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * dataSource DataSource
	 * 
	 */
	private RowMapper<JerarquiaDto<ComunicacionPrl>> rwMapJerarquia = new RowMapper<JerarquiaDto<ComunicacionPrl>>() {
		public JerarquiaDto<ComunicacionPrl> mapRow(ResultSet resultSet,
				int rowNum) throws SQLException {

			ComunicacionPrl comunicacionprl = new ComunicacionPrl(
					resultSet.getString("TIPOOS"),
					resultSet.getString("TEROS"), resultSet.getString("ANOOS"),
					resultSet.getInt("NUMOS"), resultSet.getDate("FECPRE"),
					resultSet.getDate("FECIER"), resultSet.getString("TERAPE"),
					resultSet.getString("ANOAPE"), resultSet.getInt("NUMAPE"),
					resultSet.getString("TIPDOC"),
					resultSet.getString("NUMDOC"),
					resultSet.getString("NOMEMP"),
					resultSet.getString("PAISEMP"),
					resultSet.getString("PRVEMP"),
					resultSet.getString("MUNEMP"),
					resultSet.getString("DMUNEMP"),
					resultSet.getString("DIREMP"),
					resultSet.getString("CPOEMP"),
					resultSet.getString("TLFEMP"),
					resultSet.getString("FAXEMP"),
					resultSet.getString("EMAEMP"),
					resultSet.getString("HTTPEMP"),
					resultSet.getBigDecimal("TRBTOT"),
					resultSet.getString("OBSERV"), resultSet.getInt("CODCTR"),
					resultSet.getDate("FECALT"), resultSet.getString("USUALT"),
					resultSet.getDate("FECMOD"), resultSet.getString("USUMOD"),
					resultSet.getString("DESCEMP"),
					resultSet.getString("DOCCORRECTA"),
					resultSet.getString("ESTADO"),
					resultSet.getString("FORPRE"),
					resultSet.getString("CNAEEMP"),
					resultSet.getString("INDANX"),
					resultSet.getString("APDOANX"),
					resultSet.getString("PRVCTR"),
					resultSet.getString("MUNCTR"),
					resultSet.getString("LOCCTR"),
					resultSet.getString("DIRCTR"),
					resultSet.getString("CPOCTR"),
					resultSet.getString("TIPMPR1"),
					resultSet.getString("NOMMPR1"),
					resultSet.getString("TIPMPR2"),
					resultSet.getString("NOMMPR2"),
					resultSet.getString("TOPSEG1"),
					resultSet.getString("TOPSEG2"),
					resultSet.getString("TOPHIG1"),
					resultSet.getString("TOPHIG2"),
					resultSet.getString("TOPERG1"),
					resultSet.getString("TOPERG2"),
					resultSet.getString("TOPVIG1"),
					resultSet.getString("TOPVIG2"),
					resultSet.getString("TIPRIE1"),
					resultSet.getString("NOMRIE1"),
					resultSet.getString("TIPRIE2"),
					resultSet.getString("NOMRIE2"),
					resultSet.getString("INDAUD"), resultSet.getDate("FECAUD"),
					resultSet.getString("EMPAUD"),
					resultSet.getString("DESCCEN"),
					resultSet.getString("CODEMPAUD"),
					resultSet.getString("CODPREV1"),
					resultSet.getString("CODPREV2"),
					resultSet.getString("CNAEEMP93"),
					resultSet.getString("CLASCTR"),
					resultSet.getString("DECLAR"),
					resultSet.getString("CARDEC"), resultSet.getDate("FECEVR"),
					resultSet.getString("DESRIE"),
					resultSet.getString("DESACT"),
					resultSet.getString("NUEVA"),
					resultSet.getString("MIGRADO"),
					resultSet.getString("FOLDERID"),
					resultSet.getString("CODDATOSNOTIF"),
					new DatosNotificacion(resultSet.getInt("CODDATOSNOTIF")),
					resultSet.getString("USUARIOAPE"),
					resultSet.getString("USUARIOAPORT"),
					resultSet.getString("USUARIOTRAM"),
					resultSet.getString("NUMDOCREPRESENTANTE"),
					resultSet.getString("NOMREPRESENTANTE"),
					resultSet.getString("TIPDOCREPRESENTANTE"));

			JerarquiaDto<ComunicacionPrl> jerarquia = new JerarquiaDto<ComunicacionPrl>();
			jerarquia.setModel(comunicacionprl);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet
					.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet
					.getString("FILTER")));
			return jerarquia;
		}
	};

	private RowMapper<ComunicacionApertura> rwMapDatosEtiquetas = new RowMapper<ComunicacionApertura>() {
		public ComunicacionApertura mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			ComunicacionApertura comunicacionApertura = new ComunicacionApertura();

			String terape = resultSet.getString("TERAPE") != null ? resultSet
					.getString("TERAPE") : "";
			comunicacionApertura.setTerape056(terape);

			String anoape = resultSet.getString("ANOAPE") != null ? resultSet
					.getString("ANOAPE") : "";
			comunicacionApertura.setAnoape056(anoape);

			Long numape = resultSet.getLong("NUMAPE") > 0 ? resultSet
					.getLong("NUMAPE") : 0;
			comunicacionApertura.setNumape056(numape);

			String nomemp = resultSet.getString("NOMEMP") != null ? resultSet
					.getString("NOMEMP") : "";
			comunicacionApertura.setNomemp056(nomemp);

			DatosLocalizacion datosloc = new DatosLocalizacion();
			String cp = resultSet.getString("CP") != null ? resultSet
					.getString("CP") : "";
			datosloc.setCodpostal067(cp);

			String calle = resultSet.getString("CALLE") != null ? resultSet
					.getString("CALLE") : "";
			datosloc.setCalle067(calle);

			String portal = resultSet.getString("PORTAL") != null ? resultSet
					.getString("PORTAL") : "";
			datosloc.setPortal067(portal);
			String piso = resultSet.getString("PISO") != null ? resultSet
					.getString("PISO") : "";
			datosloc.setPiso067(piso);
			String puerta = resultSet.getString("PUERTA") != null ? resultSet
					.getString("PUERTA") : "";
			datosloc.setPuerta067(puerta);

			String codprov = resultSet.getString("CODPROV") != null ? resultSet
					.getString("CODPROV") : "";
			String provdesc = resultSet.getString("PROVDESC") != null ? resultSet
					.getString("PROVDESC") : "";
			Provincia prov = new Provincia();
			prov.setCodProvincia(codprov);
			prov.setDescripcion(provdesc);
			datosloc.setProvincia(prov);

			String codmuni = resultSet.getString("CODMUNI") != null ? resultSet
					.getString("CODMUNI") : "";
			String munidesc = resultSet.getString("MUNIDESC") != null ? resultSet
					.getString("MUNIDESC") : "";
			datosloc.setMunicipio(new Municipio(codprov, codmuni, munidesc));
			String codlocalidad = resultSet.getString("CODLOCALI") != null ? resultSet
					.getString("CODLOCALI") : "";
			String localidesc = resultSet.getString("LOCALIDESC") != null ? resultSet
					.getString("LOCALIDESC") : "";
			datosloc.setLocalidad(new Localidad(codprov, codmuni, codlocalidad,
					localidesc));

			DatosNotificacion datosnotif = new DatosNotificacion();
			datosnotif.setDatosLocalizacion(datosloc);
			comunicacionApertura.setDatosNotificacion(datosnotif);

			return comunicacionApertura;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * dataSource DataSource
	 * 
	 * @param dataSource
	 *            the new data source
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the ComunicacionPrl table.
	 * 
	 * comunicacionprl ComunicacionPrl ComunicacionPrl
	 * 
	 * @param comunicacionprl
	 *            the comunicacionprl
	 * @return the comunicacion prl
	 */
	public ComunicacionPrl add(ComunicacionPrl comunicacionprl) {
		String query = "INSERT INTO VCOMUNICACION_PRL (TIPOOS, TEROS, ANOOS, NUMOS, FECPRE, FECIER, TERAPE, ANOAPE, NUMAPE, TIPDOC, NUMDOC, NOMEMP, PAISEMP, PRVEMP, MUNEMP, DMUNEMP, DIREMP, CPOEMP, TLFEMP, FAXEMP, EMAEMP, HTTPEMP, TRBTOT, OBSERV, CODCTR, FECALT, USUALT, FECMOD, USUMOD, DESCEMP, DOCCORRECTA, ESTADO, FORPRE, CNAEEMP, INDANX, APDOANX, PRVCTR, MUNCTR, LOCCTR, DIRCTR, CPOCTR, TIPMPR1, NOMMPR1, TIPMPR2, NOMMPR2, TOPSEG1, TOPSEG2, TOPHIG1, TOPHIG2, TOPERG1, TOPERG2, TOPVIG1, TOPVIG2, TIPRIE1, NOMRIE1, TIPRIE2, NOMRIE2, INDAUD, FECAUD, EMPAUD, DESCCEN, CODEMPAUD, CODPREV1, CODPREV2, CNAEEMP93, CLASCTR, DECLAR, CARDEC, FECEVR, DESRIE, DESACT, NUEVA, MIGRADO, FOLDER_ID, COD_DATOS_NOTIF) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, comunicacionprl.getTipoos(),
				comunicacionprl.getTeros(), comunicacionprl.getAnoos(),
				comunicacionprl.getNumos(), comunicacionprl.getFecpre(),
				comunicacionprl.getFecier(), comunicacionprl.getTerape(),
				comunicacionprl.getAnoape(), comunicacionprl.getNumape(),
				comunicacionprl.getTipdoc(), comunicacionprl.getNumdoc(),
				comunicacionprl.getNomemp(), comunicacionprl.getPaisemp(),
				comunicacionprl.getPrvemp(), comunicacionprl.getMunemp(),
				comunicacionprl.getDmunemp(), comunicacionprl.getDiremp(),
				comunicacionprl.getCpoemp(), comunicacionprl.getTlfemp(),
				comunicacionprl.getFaxemp(), comunicacionprl.getEmaemp(),
				comunicacionprl.getHttpemp(), comunicacionprl.getTrbtot(),
				comunicacionprl.getObserv(), comunicacionprl.getCodctr(),
				comunicacionprl.getFecalt(), comunicacionprl.getUsualt(),
				comunicacionprl.getFecmod(), comunicacionprl.getUsumod(),
				comunicacionprl.getDescemp(), comunicacionprl.getDoccorrecta(),
				comunicacionprl.getEstado(), comunicacionprl.getForpre(),
				comunicacionprl.getCnaeemp(), comunicacionprl.getIndanx(),
				comunicacionprl.getApdoanx(), comunicacionprl.getPrvctr(),
				comunicacionprl.getMunctr(), comunicacionprl.getLocctr(),
				comunicacionprl.getDirctr(), comunicacionprl.getCpoctr(),
				comunicacionprl.getTipmpr1(), comunicacionprl.getNommpr1(),
				comunicacionprl.getTipmpr2(), comunicacionprl.getNommpr2(),
				comunicacionprl.getTopseg1(), comunicacionprl.getTopseg2(),
				comunicacionprl.getTophig1(), comunicacionprl.getTophig2(),
				comunicacionprl.getToperg1(), comunicacionprl.getToperg2(),
				comunicacionprl.getTopvig1(), comunicacionprl.getTopvig2(),
				comunicacionprl.getTiprie1(), comunicacionprl.getNomrie1(),
				comunicacionprl.getTiprie2(), comunicacionprl.getNomrie2(),
				comunicacionprl.getIndaud(), comunicacionprl.getFecaud(),
				comunicacionprl.getEmpaud(), comunicacionprl.getDesccen(),
				comunicacionprl.getCodempaud(), comunicacionprl.getCodprev1(),
				comunicacionprl.getCodprev2(), comunicacionprl.getCnaeemp93(),
				comunicacionprl.getClasctr(), comunicacionprl.getDeclar(),
				comunicacionprl.getCardec(), comunicacionprl.getFecevr(),
				comunicacionprl.getDesrie(), comunicacionprl.getDesact(),
				comunicacionprl.getNueva(), comunicacionprl.getMigrado(),
				comunicacionprl.getFolderId(),
				comunicacionprl.getCoddatosnotif());
		return comunicacionprl;
	}

	/**
	 * Updates a single row in the ComunicacionPrl table.
	 * 
	 * comunicacionprl ComunicacionPrl ComunicacionPrl
	 * 
	 * @param comunicacionprl
	 *            the comunicacionprl
	 * @return the comunicacion prl
	 */
	public ComunicacionPrl update(ComunicacionPrl comunicacionprl) {
		String query = "UPDATE VCOMUNICACION_PRL SET FECPRE=? AND FECIER=? AND TERAPE=? AND ANOAPE=? AND NUMAPE=? AND TIPDOC=? AND NUMDOC=? AND NOMEMP=? AND PAISEMP=? AND PRVEMP=? AND MUNEMP=? AND DMUNEMP=? AND DIREMP=? AND CPOEMP=? AND TLFEMP=? AND FAXEMP=? AND EMAEMP=? AND HTTPEMP=? AND TRBTOT=? AND OBSERV=? AND CODCTR=? AND FECALT=? AND USUALT=? AND FECMOD=? AND USUMOD=? AND DESCEMP=? AND DOCCORRECTA=? AND ESTADO=? AND FORPRE=? AND CNAEEMP=? AND INDANX=? AND APDOANX=? AND PRVCTR=? AND MUNCTR=? AND LOCCTR=? AND DIRCTR=? AND CPOCTR=? AND TIPMPR1=? AND NOMMPR1=? AND TIPMPR2=? AND NOMMPR2=? AND TOPSEG1=? AND TOPSEG2=? AND TOPHIG1=? AND TOPHIG2=? AND TOPERG1=? AND TOPERG2=? AND TOPVIG1=? AND TOPVIG2=? AND TIPRIE1=? AND NOMRIE1=? AND TIPRIE2=? AND NOMRIE2=? AND INDAUD=? AND FECAUD=? AND EMPAUD=? AND DESCCEN=? AND CODEMPAUD=? AND CODPREV1=? AND CODPREV2=? AND CNAEEMP93=? AND CLASCTR=? AND DECLAR=? AND CARDEC=? AND FECEVR=? AND DESRIE=? AND DESACT=? AND NUEVA=? WHERE TIPOOS=? AND TEROS=? AND ANOOS=? AND NUMOS=? ";
		this.jdbcTemplate.update(query, comunicacionprl.getFecpre(),
				comunicacionprl.getFecier(), comunicacionprl.getTerape(),
				comunicacionprl.getAnoape(), comunicacionprl.getNumape(),
				comunicacionprl.getTipdoc(), comunicacionprl.getNumdoc(),
				comunicacionprl.getNomemp(), comunicacionprl.getPaisemp(),
				comunicacionprl.getPrvemp(), comunicacionprl.getMunemp(),
				comunicacionprl.getDmunemp(), comunicacionprl.getDiremp(),
				comunicacionprl.getCpoemp(), comunicacionprl.getTlfemp(),
				comunicacionprl.getFaxemp(), comunicacionprl.getEmaemp(),
				comunicacionprl.getHttpemp(), comunicacionprl.getTrbtot(),
				comunicacionprl.getObserv(), comunicacionprl.getCodctr(),
				comunicacionprl.getFecalt(), comunicacionprl.getUsualt(),
				comunicacionprl.getFecmod(), comunicacionprl.getUsumod(),
				comunicacionprl.getDescemp(), comunicacionprl.getDoccorrecta(),
				comunicacionprl.getEstado(), comunicacionprl.getForpre(),
				comunicacionprl.getCnaeemp(), comunicacionprl.getIndanx(),
				comunicacionprl.getApdoanx(), comunicacionprl.getPrvctr(),
				comunicacionprl.getMunctr(), comunicacionprl.getLocctr(),
				comunicacionprl.getDirctr(), comunicacionprl.getCpoctr(),
				comunicacionprl.getTipmpr1(), comunicacionprl.getNommpr1(),
				comunicacionprl.getTipmpr2(), comunicacionprl.getNommpr2(),
				comunicacionprl.getTopseg1(), comunicacionprl.getTopseg2(),
				comunicacionprl.getTophig1(), comunicacionprl.getTophig2(),
				comunicacionprl.getToperg1(), comunicacionprl.getToperg2(),
				comunicacionprl.getTopvig1(), comunicacionprl.getTopvig2(),
				comunicacionprl.getTiprie1(), comunicacionprl.getNomrie1(),
				comunicacionprl.getTiprie2(), comunicacionprl.getNomrie2(),
				comunicacionprl.getIndaud(), comunicacionprl.getFecaud(),
				comunicacionprl.getEmpaud(), comunicacionprl.getDesccen(),
				comunicacionprl.getCodempaud(), comunicacionprl.getCodprev1(),
				comunicacionprl.getCodprev2(), comunicacionprl.getCnaeemp93(),
				comunicacionprl.getClasctr(), comunicacionprl.getDeclar(),
				comunicacionprl.getCardec(), comunicacionprl.getFecevr(),
				comunicacionprl.getDesrie(), comunicacionprl.getDesact(),
				comunicacionprl.getNueva(), comunicacionprl.getTipoos(),
				comunicacionprl.getTeros(), comunicacionprl.getAnoos(),
				comunicacionprl.getNumos());
		return comunicacionprl;
	}

	/**
	 * Finds a single row in the ComunicacionPrl table.
	 * 
	 * comunicacionprl ComunicacionPrl ComunicacionPrl
	 * 
	 * @param comunicacionprl
	 *            the comunicacionprl
	 * @return the comunicacion prl
	 */
	@Transactional(readOnly = true)
	public ComunicacionPrl find(ComunicacionPrl comunicacionprl) {
		String query = "SELECT t1.TIPOOS TIPOOS, t1.TEROS TEROS, t1.ANOOS ANOOS, t1.NUMOS NUMOS, t1.FECPRE FECPRE, t1.FECIER FECIER, t1.TERAPE TERAPE, t1.ANOAPE ANOAPE, t1.NUMAPE NUMAPE, t1.TIPDOC TIPDOC, t1.NUMDOC NUMDOC, t1.NOMEMP NOMEMP, t1.PAISEMP PAISEMP, t1.PRVEMP PRVEMP, t1.MUNEMP MUNEMP, t1.DMUNEMP DMUNEMP, t1.DIREMP DIREMP, t1.CPOEMP CPOEMP, t1.TLFEMP TLFEMP, t1.FAXEMP FAXEMP, t1.EMAEMP EMAEMP, t1.HTTPEMP HTTPEMP, t1.TRBTOT TRBTOT, t1.OBSERV OBSERV, t1.CODCTR CODCTR, t1.FECALT FECALT, t1.USUALT USUALT, t1.FECMOD FECMOD, t1.USUMOD USUMOD, t1.DESCEMP DESCEMP, t1.DOCCORRECTA DOCCORRECTA, t1.ESTADO ESTADO, t1.FORPRE FORPRE, t1.CNAEEMP CNAEEMP, t1.INDANX INDANX, t1.APDOANX APDOANX, t1.PRVCTR PRVCTR, t1.MUNCTR MUNCTR, t1.LOCCTR LOCCTR, t1.DIRCTR DIRCTR, t1.CPOCTR CPOCTR, t1.TIPMPR1 TIPMPR1, t1.NOMMPR1 NOMMPR1, t1.TIPMPR2 TIPMPR2, t1.NOMMPR2 NOMMPR2, t1.TOPSEG1 TOPSEG1, t1.TOPSEG2 TOPSEG2, t1.TOPHIG1 TOPHIG1, t1.TOPHIG2 TOPHIG2, t1.TOPERG1 TOPERG1, t1.TOPERG2 TOPERG2, t1.TOPVIG1 TOPVIG1, t1.TOPVIG2 TOPVIG2, t1.TIPRIE1 TIPRIE1, t1.NOMRIE1 NOMRIE1, t1.TIPRIE2 TIPRIE2, t1.NOMRIE2 NOMRIE2, t1.INDAUD INDAUD, t1.FECAUD FECAUD, t1.EMPAUD EMPAUD, t1.DESCCEN DESCCEN, t1.CODEMPAUD CODEMPAUD, t1.CODPREV1 CODPREV1, t1.CODPREV2 CODPREV2, t1.CNAEEMP93 CNAEEMP93, t1.CLASCTR CLASCTR, t1.DECLAR DECLAR, t1.CARDEC CARDEC, t1.FECEVR FECEVR, t1.DESRIE DESRIE, t1.DESACT DESACT, t1.NUEVA NUEVA, t1.MIGRADO MIGRADO, t1.FOLDER_ID FOLDERID, t1.COD_DATOS_NOTIF CODDATOSNOTIF, t1.USUARIOAPE USUARIOAPE, t1.USUARIOAPORT USUARIOAPORT, t1.USUARIOTRAM USUARIOTRAM,t1.NUMDOCREPRESENTANTE NUMDOCREPRESENTANTE, t1.NOMREPRESENTANTE NOMREPRESENTANTE, t1.TIPDOCREPRESENTANTE TIPDOCREPRESENTANTE  FROM VCOMUNICACION_PRL t1  WHERE t1.TIPOOS = ?   AND t1.TEROS = ?   AND t1.ANOOS = ?   AND t1.NUMOS = ?   ";

		List<ComunicacionPrl> comunicacionprlList = this.jdbcTemplate.query(
				query, this.rwMap, comunicacionprl.getTipoos(),
				comunicacionprl.getTeros(), comunicacionprl.getAnoos(),
				comunicacionprl.getNumos());
		return (ComunicacionPrl) DataAccessUtils
				.uniqueResult(comunicacionprlList);
	}

	/**
	 * Vista find detalle.
	 * 
	 * comunicacionPrl ComunicacionPrl jqGridRequestDto JQGridRequestDto filtro
	 * ComunicacionPrl HExpediente
	 * 
	 * @param comunicacionPrl
	 *            the comunicacion prl
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param filtro
	 *            the filtro
	 * @return the comunicacion prl
	 */
	public ComunicacionPrl vistaFindDetalle(ComunicacionPrl comunicacionPrl,
			JQGridRequestDto jqGridRequestDto, ComunicacionPrl filtro) {
		StringBuilder query = new StringBuilder(
				ComunicacionPrlDaoImpl.STRING_BUILDER_INIT);
		List<ComunicacionPrl> comunicacionesPrlList = null;

		boolean anteriorSiguiente = false;
		if (jqGridRequestDto != null && filtro != null) {
			anteriorSiguiente = true;
			// Se ha hecho una peticion, para recuperar anterior y siguiente

			// CHECKSTYLE:OFF El '*' se ejecuta sobre una subselect
			query.append("SELECT * FROM ( ");
			// CHECKSTYLE:ON

			query.append(ComunicacionPrlDaoImpl.QUERY_SELECT);

			query.append(", LAG (t1.TIPOOS) OVER (ORDER BY ");
			query.append(jqGridRequestDto.getSidx()).append(" ")
					.append(jqGridRequestDto.getSord());
			query.append(") PREVIOUSTIPOOS, ");

			query.append(" LEAD (t1.TIPOOS) OVER (ORDER BY ");
			query.append(jqGridRequestDto.getSidx()).append(" ")
					.append(jqGridRequestDto.getSord());
			query.append(") NEXTTIPOOS ");

			query.append(", LAG ((t1.TEROS||'/'||t1.ANOOS||'/'||t1.NUMOS)) OVER (ORDER BY ");
			query.append(jqGridRequestDto.getSidx()).append(" ")
					.append(jqGridRequestDto.getSord());
			query.append(") PREVIOUSROW, ");
			query.append(" LEAD ((t1.TEROS||'/'||t1.ANOOS||'/'||t1.NUMOS)) OVER (ORDER BY ");
			query.append(jqGridRequestDto.getSidx()).append(" ")
					.append(jqGridRequestDto.getSord());
			query.append(") NEXTROW ");
			query.append("  FROM VCOMUNICACION_PRL t1 ");

			// Where clause & Params
			Map<String, ?> mapaWhere = this.getWhereLikeMap(filtro, false);
			StringBuilder where = new StringBuilder(" WHERE 1=1 ");
			where.append(mapaWhere.get("query"));
			query.append(where);

			List<Object> params = (List<Object>) mapaWhere.get("params");
			query.append(") WHERE TIPOOS=? AND TEROS=? AND ANOOS=? AND NUMOS=?");
			params.add(comunicacionPrl.getTipoos());
			params.add(comunicacionPrl.getTeros());
			params.add(comunicacionPrl.getAnoos());
			params.add(comunicacionPrl.getNumos());

			comunicacionesPrlList = this.jdbcTemplate.query(query.toString(),
					this.rwMap, params.toArray());

		}

		if (!anteriorSiguiente
				|| (anteriorSiguiente && comunicacionesPrlList.isEmpty())) {
			/**
			 * Se ha hecho una peticion normal, sin recuperar anterior y
			 * siguiente o se ha modificado alguna propiedad del expediente en
			 * el filtro y ya no lo encuentra al recargar el expediente
			 */
			query = new StringBuilder(
					ComunicacionPrlDaoImpl.STRING_BUILDER_INIT);
			query.append(ComunicacionPrlDaoImpl.QUERY_SELECT);
			query.append("  FROM VCOMUNICACION_PRL t1 ");
			query.append(" WHERE TEROS=? AND ANOOS=? AND NUMOS=? AND TIPOOS = ? ");

			comunicacionesPrlList = this.jdbcTemplate.query(query.toString(),
					this.rwMap, comunicacionPrl.getTeros(),
					comunicacionPrl.getAnoos(), comunicacionPrl.getNumos(),
					comunicacionPrl.getTipoos());
		}
		// return (ComunicacionApertura) DataAccessUtils
		// .uniqueResult(comunicacionesApeList);
		return comunicacionesPrlList.get(0);
	}

	/**
	 * Removes a single row in the ComunicacionPrl table.
	 * 
	 * comunicacionprl ComunicacionPrl
	 * 
	 * @param comunicacionprl
	 *            the comunicacionprl
	 */
	public void remove(ComunicacionPrl comunicacionprl) {
		String query = "DELETE FROM VCOMUNICACION_PRL WHERE TIPOOS=? AND TEROS=? AND ANOOS=? AND NUMOS=? ";
		this.jdbcTemplate.update(query, comunicacionprl.getTipoos(),
				comunicacionprl.getTeros(), comunicacionprl.getAnoos(),
				comunicacionprl.getNumos());
	}

	/**
	 * Finds a list of rows in the ComunicacionPrl table.
	 * 
	 * comunicacionprl ComunicacionPrl jqGridRequestDto JQGridRequestDto List
	 * <ComunicacionPrl>
	 * 
	 * @param comunicacionprl
	 *            the comunicacionprl
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<ComunicacionPrl> findAll(ComunicacionPrl comunicacionprl,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.TIPOOS TIPOOS,t1.TEROS TEROS,t1.ANOOS ANOOS,t1.NUMOS NUMOS,t1.FECPRE FECPRE,t1.FECIER FECIER,t1.TERAPE TERAPE,t1.ANOAPE ANOAPE,t1.NUMAPE NUMAPE,t1.TIPDOC TIPDOC,t1.NUMDOC NUMDOC,t1.NOMEMP NOMEMP,t1.PAISEMP PAISEMP,t1.PRVEMP PRVEMP,t1.MUNEMP MUNEMP,t1.DMUNEMP DMUNEMP,t1.DIREMP DIREMP,t1.CPOEMP CPOEMP,t1.TLFEMP TLFEMP,t1.FAXEMP FAXEMP,t1.EMAEMP EMAEMP,t1.HTTPEMP HTTPEMP,t1.TRBTOT TRBTOT,t1.OBSERV OBSERV,t1.CODCTR CODCTR,t1.FECALT FECALT,t1.USUALT USUALT,t1.FECMOD FECMOD,t1.USUMOD USUMOD,t1.DESCEMP DESCEMP,t1.DOCCORRECTA DOCCORRECTA,t1.ESTADO ESTADO,t1.FORPRE FORPRE,t1.CNAEEMP CNAEEMP,t1.INDANX INDANX,t1.APDOANX APDOANX,t1.PRVCTR PRVCTR,t1.MUNCTR MUNCTR,t1.LOCCTR LOCCTR,t1.DIRCTR DIRCTR,t1.CPOCTR CPOCTR,t1.TIPMPR1 TIPMPR1,t1.NOMMPR1 NOMMPR1,t1.TIPMPR2 TIPMPR2,t1.NOMMPR2 NOMMPR2,t1.TOPSEG1 TOPSEG1,t1.TOPSEG2 TOPSEG2,t1.TOPHIG1 TOPHIG1,t1.TOPHIG2 TOPHIG2,t1.TOPERG1 TOPERG1,t1.TOPERG2 TOPERG2,t1.TOPVIG1 TOPVIG1,t1.TOPVIG2 TOPVIG2,t1.TIPRIE1 TIPRIE1,t1.NOMRIE1 NOMRIE1,t1.TIPRIE2 TIPRIE2,t1.NOMRIE2 NOMRIE2,t1.INDAUD INDAUD,t1.FECAUD FECAUD,t1.EMPAUD EMPAUD,t1.DESCCEN DESCCEN,t1.CODEMPAUD CODEMPAUD,t1.CODPREV1 CODPREV1,t1.CODPREV2 CODPREV2,t1.CNAEEMP93 CNAEEMP93,t1.CLASCTR CLASCTR,t1.DECLAR DECLAR,t1.CARDEC CARDEC,t1.FECEVR FECEVR,t1.DESRIE DESRIE,t1.DESACT DESACT,t1.NUEVA NUEVA, t1.MIGRADO MIGRADO, t1.FOLDER_ID FOLDERID, t1.COD_DATOS_NOTIF CODDATOSNOTIF, t1.USUARIOAPE USUARIOAPE, t1.USUARIOAPORT USUARIOAPORT, t1.USUARIOTRAM USUARIOTRAM,t1.NUMDOCREPRESENTANTE NUMDOCREPRESENTANTE, t1.NOMREPRESENTANTE NOMREPRESENTANTE, t1.TIPDOCREPRESENTANTE TIPDOCREPRESENTANTE  ");
		query.append("FROM VCOMUNICACION_PRL t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(comunicacionprl);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<ComunicacionPrl>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the ComunicacionPrl table using like.
	 * 
	 * comunicacionprl ComunicacionPrl jqGridRequestDto JQGridRequestDto
	 * startsWith Boolean List<ComunicacionPrl>
	 * 
	 * @param comunicacionprl
	 *            the comunicacionprl
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<ComunicacionPrl> findAllLike(ComunicacionPrl comunicacionprl,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				ComunicacionPrlDaoImpl.QUERY_SELECT);
		query.append("FROM VCOMUNICACION_PRL t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(comunicacionprl,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<ComunicacionPrl>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the ComunicacionPrl table.
	 * 
	 * comunicacionprl ComunicacionPrl Long
	 * 
	 * @param comunicacionprl
	 *            the comunicacionprl
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(ComunicacionPrl comunicacionprl) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM VCOMUNICACION_PRL t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(comunicacionprl);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the ComunicacionPrl table using like.
	 * 
	 * comunicacionprl ComunicacionPrl startsWith Boolean Long
	 * 
	 * @param comunicacionprl
	 *            the comunicacionprl
	 * @param startsWith
	 *            the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(ComunicacionPrl comunicacionprl,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM VCOMUNICACION_PRL t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(comunicacionprl,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of ComunicacionPrl selected for rup_table.
	 * 
	 * comunicacionprl ComunicacionPrl jqGridRequestDto JQGridRequestDto
	 * startsWith Boolean List<TableRowDto<ComunicacionPrl>>
	 * 
	 * @param comunicacionprl
	 *            the comunicacionprl
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<ComunicacionPrl>> reorderSelection(
			ComunicacionPrl comunicacionprl, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.TIPOOS TIPOOS,t1.TEROS TEROS,t1.ANOOS ANOOS,t1.NUMOS NUMOS,t1.FECPRE FECPRE,t1.FECIER FECIER,t1.TERAPE TERAPE,t1.ANOAPE ANOAPE,t1.NUMAPE NUMAPE,t1.TIPDOC TIPDOC,t1.NUMDOC NUMDOC,t1.NOMEMP NOMEMP,t1.PAISEMP PAISEMP,t1.PRVEMP PRVEMP,t1.MUNEMP MUNEMP,t1.DMUNEMP DMUNEMP,t1.DIREMP DIREMP,t1.CPOEMP CPOEMP,t1.TLFEMP TLFEMP,t1.FAXEMP FAXEMP,t1.EMAEMP EMAEMP,t1.HTTPEMP HTTPEMP,t1.TRBTOT TRBTOT,t1.OBSERV OBSERV,t1.CODCTR CODCTR,t1.FECALT FECALT,t1.USUALT USUALT,t1.FECMOD FECMOD,t1.USUMOD USUMOD,t1.DESCEMP DESCEMP,t1.DOCCORRECTA DOCCORRECTA,t1.ESTADO ESTADO,t1.FORPRE FORPRE,t1.CNAEEMP CNAEEMP,t1.INDANX INDANX,t1.APDOANX APDOANX,t1.PRVCTR PRVCTR,t1.MUNCTR MUNCTR,t1.LOCCTR LOCCTR,t1.DIRCTR DIRCTR,t1.CPOCTR CPOCTR,t1.TIPMPR1 TIPMPR1,t1.NOMMPR1 NOMMPR1,t1.TIPMPR2 TIPMPR2,t1.NOMMPR2 NOMMPR2,t1.TOPSEG1 TOPSEG1,t1.TOPSEG2 TOPSEG2,t1.TOPHIG1 TOPHIG1,t1.TOPHIG2 TOPHIG2,t1.TOPERG1 TOPERG1,t1.TOPERG2 TOPERG2,t1.TOPVIG1 TOPVIG1,t1.TOPVIG2 TOPVIG2,t1.TIPRIE1 TIPRIE1,t1.NOMRIE1 NOMRIE1,t1.TIPRIE2 TIPRIE2,t1.NOMRIE2 NOMRIE2,t1.INDAUD INDAUD,t1.FECAUD FECAUD,t1.EMPAUD EMPAUD,t1.DESCCEN DESCCEN,t1.CODEMPAUD CODEMPAUD,t1.CODPREV1 CODPREV1,t1.CODPREV2 CODPREV2,t1.CNAEEMP93 CNAEEMP93,t1.CLASCTR CLASCTR,t1.DECLAR DECLAR,t1.CARDEC CARDEC,t1.FECEVR FECEVR,t1.DESRIE DESRIE,t1.DESACT DESACT,t1.NUEVA NUEVA, t1.MIGRADO MIGRADO, t1.FOLDER_ID FOLDERID, t1.COD_DATOS_NOTIF CODDATOSNOTIF, t1.USUARIOAPE USUARIOAPE, t1.USUARIOAPORT USUARIOAPORT, t1.USUARIOTRAM USUARIOTRAM  ");
		// FROM
		query.append("FROM VCOMUNICACION_PRL t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(comunicacionprl,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, ComunicacionPrl.class,
				filterParamList, "TIPOOS,TEROS,ANOOS,NUMOS");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<ComunicacionPrl>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 * filterParams ComunicacionPrl searchParams ComunicacionPrl
	 * jqGridRequestDto JQGridRequestDto startsWith Boolean List<TableRowDto
	 * <ComunicacionPrl>>
	 * 
	 * @param filterParams
	 *            the filter params
	 * @param searchParams
	 *            the search params
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<ComunicacionPrl>> search(
			ComunicacionPrl filterParams, ComunicacionPrl searchParams,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.TIPOOS TIPOOS,t1.TEROS TEROS,t1.ANOOS ANOOS,t1.NUMOS NUMOS,t1.FECPRE FECPRE,t1.FECIER FECIER,t1.TERAPE TERAPE,t1.ANOAPE ANOAPE,t1.NUMAPE NUMAPE,t1.TIPDOC TIPDOC,t1.NUMDOC NUMDOC,t1.NOMEMP NOMEMP,t1.PAISEMP PAISEMP,t1.PRVEMP PRVEMP,t1.MUNEMP MUNEMP,t1.DMUNEMP DMUNEMP,t1.DIREMP DIREMP,t1.CPOEMP CPOEMP,t1.TLFEMP TLFEMP,t1.FAXEMP FAXEMP,t1.EMAEMP EMAEMP,t1.HTTPEMP HTTPEMP,t1.TRBTOT TRBTOT,t1.OBSERV OBSERV,t1.CODCTR CODCTR,t1.FECALT FECALT,t1.USUALT USUALT,t1.FECMOD FECMOD,t1.USUMOD USUMOD,t1.DESCEMP DESCEMP,t1.DOCCORRECTA DOCCORRECTA,t1.ESTADO ESTADO,t1.FORPRE FORPRE,t1.CNAEEMP CNAEEMP,t1.INDANX INDANX,t1.APDOANX APDOANX,t1.PRVCTR PRVCTR,t1.MUNCTR MUNCTR,t1.LOCCTR LOCCTR,t1.DIRCTR DIRCTR,t1.CPOCTR CPOCTR,t1.TIPMPR1 TIPMPR1,t1.NOMMPR1 NOMMPR1,t1.TIPMPR2 TIPMPR2,t1.NOMMPR2 NOMMPR2,t1.TOPSEG1 TOPSEG1,t1.TOPSEG2 TOPSEG2,t1.TOPHIG1 TOPHIG1,t1.TOPHIG2 TOPHIG2,t1.TOPERG1 TOPERG1,t1.TOPERG2 TOPERG2,t1.TOPVIG1 TOPVIG1,t1.TOPVIG2 TOPVIG2,t1.TIPRIE1 TIPRIE1,t1.NOMRIE1 NOMRIE1,t1.TIPRIE2 TIPRIE2,t1.NOMRIE2 NOMRIE2,t1.INDAUD INDAUD,t1.FECAUD FECAUD,t1.EMPAUD EMPAUD,t1.DESCCEN DESCCEN,t1.CODEMPAUD CODEMPAUD,t1.CODPREV1 CODPREV1,t1.CODPREV2 CODPREV2,t1.CNAEEMP93 CNAEEMP93,t1.CLASCTR CLASCTR,t1.DECLAR DECLAR,t1.CARDEC CARDEC,t1.FECEVR FECEVR,t1.DESRIE DESRIE,t1.DESACT DESACT,t1.NUEVA NUEVA, t1.MIGRADO MIGRADO, t1.FOLDER_ID FOLDERID, t1.COD_DATOS_NOTIF CODDATOSNOTIF, t1.USUARIOAPE USUARIOAPE, t1.USUARIOAPORT USUARIOAPORT, t1.USUARIOTRAM USUARIOTRAM  ");
		// FROM
		query.append("FROM VCOMUNICACION_PRL t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager
				.getSearchQuery(
						query,
						jqGridRequestDto,
						ComunicacionPrl.class,
						filterParamList,
						searchSQL,
						searchParamList,
						from_alias,
						"TIPOOS,TEROS,ANOOS,NUMOS,FECPRE,FECIER,TERAPE,ANOAPE,NUMAPE,TIPDOC,NUMDOC,NOMEMP,PAISEMP,PRVEMP,MUNEMP,DMUNEMP,DIREMP,CPOEMP,TLFEMP,FAXEMP,EMAEMP,HTTPEMP,TRBTOT,OBSERV,CODCTR,FECALT,USUALT,FECMOD,USUMOD,DESCEMP,DOCCORRECTA,ESTADO,FORPRE,CNAEEMP,INDANX,APDOANX,PRVCTR,MUNCTR,LOCCTR,DIRCTR,CPOCTR,TIPMPR1,NOMMPR1,TIPMPR2,NOMMPR2,TOPSEG1,TOPSEG2,TOPHIG1,TOPHIG2,TOPERG1,TOPERG2,TOPVIG1,TOPVIG2,TIPRIE1,NOMRIE1,TIPRIE2,NOMRIE2,INDAUD,FECAUD,EMPAUD,DESCCEN,CODEMPAUD,CODPREV1,CODPREV2,CNAEEMP93,CLASCTR,DECLAR,CARDEC,FECEVR,DESRIE,DESACT,NUEVA");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<ComunicacionPrl>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table.
	 * 
	 * filtercomunicacionprl ComunicacionPrl jqGridRequestDto JQGridRequestDto
	 * startsWith Boolean
	 * 
	 * @param filtercomunicacionprl
	 *            the filtercomunicacionprl
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 */
	@Override
	public void removeMultiple(ComunicacionPrl filtercomunicacionprl,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.TIPOOS TIPOOS,t1.TEROS TEROS,t1.ANOOS ANOOS,t1.NUMOS NUMOS,t1.FECPRE FECPRE,t1.FECIER FECIER,t1.TERAPE TERAPE,t1.ANOAPE ANOAPE,t1.NUMAPE NUMAPE,t1.TIPDOC TIPDOC,t1.NUMDOC NUMDOC,t1.NOMEMP NOMEMP,t1.PAISEMP PAISEMP,t1.PRVEMP PRVEMP,t1.MUNEMP MUNEMP,t1.DMUNEMP DMUNEMP,t1.DIREMP DIREMP,t1.CPOEMP CPOEMP,t1.TLFEMP TLFEMP,t1.FAXEMP FAXEMP,t1.EMAEMP EMAEMP,t1.HTTPEMP HTTPEMP,t1.TRBTOT TRBTOT,t1.OBSERV OBSERV,t1.CODCTR CODCTR,t1.FECALT FECALT,t1.USUALT USUALT,t1.FECMOD FECMOD,t1.USUMOD USUMOD,t1.DESCEMP DESCEMP,t1.DOCCORRECTA DOCCORRECTA,t1.ESTADO ESTADO,t1.FORPRE FORPRE,t1.CNAEEMP CNAEEMP,t1.INDANX INDANX,t1.APDOANX APDOANX,t1.PRVCTR PRVCTR,t1.MUNCTR MUNCTR,t1.LOCCTR LOCCTR,t1.DIRCTR DIRCTR,t1.CPOCTR CPOCTR,t1.TIPMPR1 TIPMPR1,t1.NOMMPR1 NOMMPR1,t1.TIPMPR2 TIPMPR2,t1.NOMMPR2 NOMMPR2,t1.TOPSEG1 TOPSEG1,t1.TOPSEG2 TOPSEG2,t1.TOPHIG1 TOPHIG1,t1.TOPHIG2 TOPHIG2,t1.TOPERG1 TOPERG1,t1.TOPERG2 TOPERG2,t1.TOPVIG1 TOPVIG1,t1.TOPVIG2 TOPVIG2,t1.TIPRIE1 TIPRIE1,t1.NOMRIE1 NOMRIE1,t1.TIPRIE2 TIPRIE2,t1.NOMRIE2 NOMRIE2,t1.INDAUD INDAUD,t1.FECAUD FECAUD,t1.EMPAUD EMPAUD,t1.DESCCEN DESCCEN,t1.CODEMPAUD CODEMPAUD,t1.CODPREV1 CODPREV1,t1.CODPREV2 CODPREV2,t1.CNAEEMP93 CNAEEMP93,t1.CLASCTR CLASCTR,t1.DECLAR DECLAR,t1.CARDEC CARDEC,t1.FECEVR FECEVR,t1.DESRIE DESRIE,t1.DESACT DESACT,t1.NUEVA NUEVA, t1.MIGRADO MIGRADO, t1.FOLDER_ID FOLDERID, t1.COD_DATOS_NOTIF CODDATOSNOTIF, t1.USUARIOAPE USUARIOAPE, t1.USUARIOAPORT USUARIOAPORT, t1.USUARIOTRAM USUARIOTRAM  ");
		// FROM
		query.append("FROM VCOMUNICACION_PRL t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(
				filtercomunicacionprl, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(
						jqGridRequestDto,
						ComunicacionPrl.class,
						query,
						params,
						"TIPOOS,TEROS,ANOOS,NUMOS,FECPRE,FECIER,TERAPE,ANOAPE,NUMAPE,TIPDOC,NUMDOC,NOMEMP,PAISEMP,PRVEMP,MUNEMP,DMUNEMP,DIREMP,CPOEMP,TLFEMP,FAXEMP,EMAEMP,HTTPEMP,TRBTOT,OBSERV,CODCTR,FECALT,USUALT,FECMOD,USUMOD,DESCEMP,DOCCORRECTA,ESTADO,FORPRE,CNAEEMP,INDANX,APDOANX,PRVCTR,MUNCTR,LOCCTR,DIRCTR,CPOCTR,TIPMPR1,NOMMPR1,TIPMPR2,NOMMPR2,TOPSEG1,TOPSEG2,TOPHIG1,TOPHIG2,TOPERG1,TOPERG2,TOPVIG1,TOPVIG2,TIPRIE1,NOMRIE1,TIPRIE2,NOMRIE2,INDAUD,FECAUD,EMPAUD,DESCCEN,CODEMPAUD,CODPREV1,CODPREV2,CNAEEMP93,CLASCTR,DECLAR,CARDEC,FECEVR,DESRIE,DESACT,NUEVA, MIGRADO, FOLDER_ID, COD_DATOS_NOTIF");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical ComunicacionPrl table.
	 * 
	 * filterComunicacionPrl ComunicacionPrl jqGridRequestDto JQGridRequestDto
	 * List<JerarquiaDto<ComunicacionPrl>>
	 * 
	 * @param filterComunicacionPrl
	 *            the filter comunicacion prl
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	@Override
	public List<JerarquiaDto<ComunicacionPrl>> findAllLikeJerarquia(
			ComunicacionPrl filterComunicacionPrl,
			JQGridRequestDto jqGridRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.TIPOOS TIPOOS,t1.TEROS TEROS,t1.ANOOS ANOOS,t1.NUMOS NUMOS,t1.FECPRE FECPRE,t1.FECIER FECIER,t1.TERAPE TERAPE,t1.ANOAPE ANOAPE,t1.NUMAPE NUMAPE,t1.TIPDOC TIPDOC,t1.NUMDOC NUMDOC,t1.NOMEMP NOMEMP,t1.PAISEMP PAISEMP,t1.PRVEMP PRVEMP,t1.MUNEMP MUNEMP,t1.DMUNEMP DMUNEMP,t1.DIREMP DIREMP,t1.CPOEMP CPOEMP,t1.TLFEMP TLFEMP,t1.FAXEMP FAXEMP,t1.EMAEMP EMAEMP,t1.HTTPEMP HTTPEMP,t1.TRBTOT TRBTOT,t1.OBSERV OBSERV,t1.CODCTR CODCTR,t1.FECALT FECALT,t1.USUALT USUALT,t1.FECMOD FECMOD,t1.USUMOD USUMOD,t1.DESCEMP DESCEMP,t1.DOCCORRECTA DOCCORRECTA,t1.ESTADO ESTADO,t1.FORPRE FORPRE,t1.CNAEEMP CNAEEMP,t1.INDANX INDANX,t1.APDOANX APDOANX,t1.PRVCTR PRVCTR,t1.MUNCTR MUNCTR,t1.LOCCTR LOCCTR,t1.DIRCTR DIRCTR,t1.CPOCTR CPOCTR,t1.TIPMPR1 TIPMPR1,t1.NOMMPR1 NOMMPR1,t1.TIPMPR2 TIPMPR2,t1.NOMMPR2 NOMMPR2,t1.TOPSEG1 TOPSEG1,t1.TOPSEG2 TOPSEG2,t1.TOPHIG1 TOPHIG1,t1.TOPHIG2 TOPHIG2,t1.TOPERG1 TOPERG1,t1.TOPERG2 TOPERG2,t1.TOPVIG1 TOPVIG1,t1.TOPVIG2 TOPVIG2,t1.TIPRIE1 TIPRIE1,t1.NOMRIE1 NOMRIE1,t1.TIPRIE2 TIPRIE2,t1.NOMRIE2 NOMRIE2,t1.INDAUD INDAUD,t1.FECAUD FECAUD,t1.EMPAUD EMPAUD,t1.DESCCEN DESCCEN,t1.CODEMPAUD CODEMPAUD,t1.CODPREV1 CODPREV1,t1.CODPREV2 CODPREV2,t1.CNAEEMP93 CNAEEMP93,t1.CLASCTR CLASCTR,t1.DECLAR DECLAR,t1.CARDEC CARDEC,t1.FECEVR FECEVR,t1.DESRIE DESRIE,t1.DESACT DESACT,t1.NUEVA NUEVA, t1.MIGRADO MIGRADO, t1.FOLDER_ID FOLDERID, t1.COD_DATOS_NOTIF CODDATOSNOTIF ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM VCOMUNICACION_PRL t1 ");
		List<String> from = new ArrayList<String>();
		from.add("VCOMUNICACION_PRL");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder(""); joins.append(
		 * "AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>(); businessFilters.append(
		 * "   AND t1.EJIE = ?  "); businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterComunicacionPrl,
				false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia
				.getQuery(
						jqGridRequestDto,
						query,
						mapaWhere,
						"TIPOOS,TEROS,ANOOS,NUMOS,FECPRE,FECIER,TERAPE,ANOAPE,NUMAPE,TIPDOC,NUMDOC,NOMEMP,PAISEMP,PRVEMP,MUNEMP,DMUNEMP,DIREMP,CPOEMP,TLFEMP,FAXEMP,EMAEMP,HTTPEMP,TRBTOT,OBSERV,CODCTR,FECALT,USUALT,FECMOD,USUMOD,DESCEMP,DOCCORRECTA,ESTADO,FORPRE,CNAEEMP,INDANX,APDOANX,PRVCTR,MUNCTR,LOCCTR,DIRCTR,CPOCTR,TIPMPR1,NOMMPR1,TIPMPR2,NOMMPR2,TOPSEG1,TOPSEG2,TOPHIG1,TOPHIG2,TOPERG1,TOPERG2,TOPVIG1,TOPVIG2,TIPRIE1,NOMRIE1,TIPRIE2,NOMRIE2,INDAUD,FECAUD,EMPAUD,DESCCEN,CODEMPAUD,CODPREV1,CODPREV2,CNAEEMP93,CLASCTR,DECLAR,CARDEC,FECEVR,DESRIE,DESACT,NUEVA",
						"ID_PADRE", "NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy.
	 * 
	 * filterComunicacionPrl ComunicacionPrl jqGridRequestDto JQGridRequestDto
	 * Long
	 * 
	 * @param filterComunicacionPrl
	 *            the filter comunicacion prl
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the long
	 */
	@Override
	public Long findAllLikeCountJerarquia(
			ComunicacionPrl filterComunicacionPrl,
			JQGridRequestDto jqGridRequestDto) {
		// FROM
		// StringBuilder from = new StringBuilder("FROM VCOMUNICACION_PRL t1 ");
		List<String> from = new ArrayList<String>();
		from.add("VCOMUNICACION_PRL");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder(""); joins.append(
		 * "AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>(); businessFilters.append(
		 * "   AND t1.EJIE = ?  "); businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterComunicacionPrl,
				false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia
				.getQueryCount(
						jqGridRequestDto,
						mapaWhere,
						"TIPOOS,TEROS,ANOOS,NUMOS,FECPRE,FECIER,TERAPE,ANOAPE,NUMAPE,TIPDOC,NUMDOC,NOMEMP,PAISEMP,PRVEMP,MUNEMP,DMUNEMP,DIREMP,CPOEMP,TLFEMP,FAXEMP,EMAEMP,HTTPEMP,TRBTOT,OBSERV,CODCTR,FECALT,USUALT,FECMOD,USUMOD,DESCEMP,DOCCORRECTA,ESTADO,FORPRE,CNAEEMP,INDANX,APDOANX,PRVCTR,MUNCTR,LOCCTR,DIRCTR,CPOCTR,TIPMPR1,NOMMPR1,TIPMPR2,NOMMPR2,TOPSEG1,TOPSEG2,TOPHIG1,TOPHIG2,TOPERG1,TOPERG2,TOPVIG1,TOPVIG2,TIPRIE1,NOMRIE1,TIPRIE2,NOMRIE2,INDAUD,FECAUD,EMPAUD,DESCCEN,CODEMPAUD,CODPREV1,CODPREV2,CNAEEMP93,CLASCTR,DECLAR,CARDEC,FECEVR,DESRIE,DESACT,NUEVA, MIGRADO, FOLDER_ID, COD_DATOS_NOTIF ",
						"ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows.
	 * 
	 * filterComunicacionPrl ComunicacionPrl jqGridRequestDto JQGridRequestDto
	 * List<TableRowDto<ComunicacionPrl>>
	 * 
	 * @param filterComunicacionPrl
	 *            the filter comunicacion prl
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	@Override
	public List<TableRowDto<ComunicacionPrl>> findAllChild(
			ComunicacionPrl filterComunicacionPrl,
			JQGridRequestDto jqGridRequestDto) {

		// FROM
		// StringBuilder from = new StringBuilder("FROM VCOMUNICACION_PRL t1 ");
		List<String> from = new ArrayList<String>();
		from.add("VCOMUNICACION_PRL");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder(""); joins.append(
		 * "AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>(); businessFilters.append(
		 * "   AND t1.EJIE = ?  "); businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterComunicacionPrl,
				false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia
				.getQueryChildren(
						jqGridRequestDto,
						mapaWhere,
						"TIPOOS,TEROS,ANOOS,NUMOS,FECPRE,FECIER,TERAPE,ANOAPE,NUMAPE,TIPDOC,NUMDOC,NOMEMP,PAISEMP,PRVEMP,MUNEMP,DMUNEMP,DIREMP,CPOEMP,TLFEMP,FAXEMP,EMAEMP,HTTPEMP,TRBTOT,OBSERV,CODCTR,FECALT,USUALT,FECMOD,USUMOD,DESCEMP,DOCCORRECTA,ESTADO,FORPRE,CNAEEMP,INDANX,APDOANX,PRVCTR,MUNCTR,LOCCTR,DIRCTR,CPOCTR,TIPMPR1,NOMMPR1,TIPMPR2,NOMMPR2,TOPSEG1,TOPSEG2,TOPHIG1,TOPHIG2,TOPERG1,TOPERG2,TOPVIG1,TOPVIG2,TIPRIE1,NOMRIE1,TIPRIE2,NOMRIE2,INDAUD,FECAUD,EMPAUD,DESCCEN,CODEMPAUD,CODPREV1,CODPREV2,CNAEEMP93,CLASCTR,DECLAR,CARDEC,FECEVR,DESRIE,DESACT,NUEVA,MIGRADO,FOLDER_ID,COD_DATOS_NOTIF",
						"ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate
				.query(query.toString(),
						new RowNumResultSetExtractor<ComunicacionPrl>(
								this.rwMapPK,
								"TIPOOS,TEROS,ANOOS,NUMOS,FECPRE,FECIER,TERAPE,ANOAPE,NUMAPE,TIPDOC,NUMDOC,NOMEMP,PAISEMP,PRVEMP,MUNEMP,DMUNEMP,DIREMP,CPOEMP,TLFEMP,FAXEMP,EMAEMP,HTTPEMP,TRBTOT,OBSERV,CODCTR,FECALT,USUALT,FECMOD,USUMOD,DESCEMP,DOCCORRECTA,ESTADO,FORPRE,CNAEEMP,INDANX,APDOANX,PRVCTR,MUNCTR,LOCCTR,DIRCTR,CPOCTR,TIPMPR1,NOMMPR1,TIPMPR2,NOMMPR2,TOPSEG1,TOPSEG2,TOPHIG1,TOPHIG2,TOPERG1,TOPERG2,TOPVIG1,TOPVIG2,TIPRIE1,NOMRIE1,TIPRIE2,NOMRIE2,INDAUD,FECAUD,EMPAUD,DESCCEN,CODEMPAUD,CODPREV1,CODPREV2,CNAEEMP93,CLASCTR,DECLAR,CARDEC,FECEVR,DESRIE,DESACT,NUEVA,MIGRADO,FOLDER_ID,COD_DATOS_NOTIF"),
						params.toArray());
	}

	/**
	 * Finds rows in the ComunicacionPrl table using like.
	 * 
	 * comunicacionPrl ComunicacionPrl List<ComunicacionPrl>
	 * 
	 * @param comunicacionPrl
	 *            the comunicacion prl
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<ComunicacionPrl> findEmpresa(ComunicacionPrl comunicacionPrl) {
		StringBuilder query = new StringBuilder(
				ComunicacionPrlDaoImpl.QUERY_SELECT);
		query.append(" FROM VCOMUNICACION_PRL t1 ");
		query.append("WHERE  UPPER(TIPOOS) = UPPER('"
				+ comunicacionPrl.getTipoos() + "') AND ");
		query.append(" UPPER(TIPDOC) = UPPER('" + comunicacionPrl.getTipdoc()
				+ "') AND ");
		query.append(" UPPER(NUMDOC) = UPPER('" + comunicacionPrl.getNumdoc()
				+ "') ");
		query.append("	AND FECPRE = (SELECT MAX(FECPRE)").append(
				" FROM VCOMUNICACION_PRL t1 ");
		query.append("  WHERE ");
		query.append(" UPPER(TIPOOS) = UPPER('" + comunicacionPrl.getTipoos()
				+ "') AND ");
		query.append(" UPPER(TIPDOC) = UPPER('" + comunicacionPrl.getTipdoc()
				+ "') AND ");
		query.append(" UPPER(NUMDOC) = UPPER('" + comunicacionPrl.getNumdoc()
				+ "'))");

		return (List<ComunicacionPrl>) this.jdbcTemplate.query(
				query.toString(), this.rwMap);
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the ComunicacionPrl entity.
	 * 
	 * comunicacionprl ComunicacionPrl Bean with the criteria values to filter
	 * by. Map created with two keys key query stores the sql query syntax key
	 * params stores the parameter values to be used in the condition sentence.
	 * 
	 * @param comunicacionprl
	 *            the comunicacionprl
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(ComunicacionPrl comunicacionprl) {

		StringBuilder where = new StringBuilder(
				ComunicacionPrlDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (comunicacionprl != null && comunicacionprl.getTipoos() != null) {
			where.append(" AND t1.TIPOOS = ?");
			params.add(comunicacionprl.getTipoos());
		}
		if (comunicacionprl != null && comunicacionprl.getTeros() != null) {
			where.append(" AND t1.TEROS = ?");
			params.add(comunicacionprl.getTeros());
		}
		if (comunicacionprl != null && comunicacionprl.getAnoos() != null) {
			where.append(" AND t1.ANOOS = ?");
			params.add(comunicacionprl.getAnoos());
		}
		if (comunicacionprl != null && comunicacionprl.getNumos() != null) {
			where.append(" AND t1.NUMOS = ?");
			params.add(comunicacionprl.getNumos());
		}
		if (comunicacionprl != null && comunicacionprl.getFecpre() != null) {
			where.append(" AND t1.FECPRE = ?");
			params.add(comunicacionprl.getFecpre());
		}
		if (comunicacionprl != null && comunicacionprl.getFecier() != null) {
			where.append(" AND t1.FECIER = ?");
			params.add(comunicacionprl.getFecier());
		}
		if (comunicacionprl != null && comunicacionprl.getTerape() != null) {
			where.append(" AND t1.TERAPE = ?");
			params.add(comunicacionprl.getTerape());
		}
		if (comunicacionprl != null && comunicacionprl.getAnoape() != null) {
			where.append(" AND t1.ANOAPE = ?");
			params.add(comunicacionprl.getAnoape());
		}
		if (comunicacionprl != null && comunicacionprl.getNumape() != null) {
			where.append(" AND t1.NUMAPE = ?");
			params.add(comunicacionprl.getNumape());
		}
		if (comunicacionprl != null && comunicacionprl.getTipdoc() != null) {
			where.append(" AND t1.TIPDOC = ?");
			params.add(comunicacionprl.getTipdoc());
		}
		if (comunicacionprl != null && comunicacionprl.getNumdoc() != null) {
			where.append(" AND t1.NUMDOC = ?");
			params.add(comunicacionprl.getNumdoc());
		}
		if (comunicacionprl != null && comunicacionprl.getNomemp() != null) {
			where.append(" AND t1.NOMEMP = ?");
			params.add(comunicacionprl.getNomemp());
		}
		if (comunicacionprl != null && comunicacionprl.getPaisemp() != null) {
			where.append(" AND t1.PAISEMP = ?");
			params.add(comunicacionprl.getPaisemp());
		}
		if (comunicacionprl != null && comunicacionprl.getPrvemp() != null) {
			where.append(" AND t1.PRVEMP = ?");
			params.add(comunicacionprl.getPrvemp());
		}
		if (comunicacionprl != null && comunicacionprl.getMunemp() != null) {
			where.append(" AND t1.MUNEMP = ?");
			params.add(comunicacionprl.getMunemp());
		}
		if (comunicacionprl != null && comunicacionprl.getDmunemp() != null) {
			where.append(" AND t1.DMUNEMP = ?");
			params.add(comunicacionprl.getDmunemp());
		}
		if (comunicacionprl != null && comunicacionprl.getDiremp() != null) {
			where.append(" AND t1.DIREMP = ?");
			params.add(comunicacionprl.getDiremp());
		}
		if (comunicacionprl != null && comunicacionprl.getCpoemp() != null) {
			where.append(" AND t1.CPOEMP = ?");
			params.add(comunicacionprl.getCpoemp());
		}
		if (comunicacionprl != null && comunicacionprl.getTlfemp() != null) {
			where.append(" AND t1.TLFEMP = ?");
			params.add(comunicacionprl.getTlfemp());
		}
		if (comunicacionprl != null && comunicacionprl.getFaxemp() != null) {
			where.append(" AND t1.FAXEMP = ?");
			params.add(comunicacionprl.getFaxemp());
		}
		if (comunicacionprl != null && comunicacionprl.getEmaemp() != null) {
			where.append(" AND t1.EMAEMP = ?");
			params.add(comunicacionprl.getEmaemp());
		}
		if (comunicacionprl != null && comunicacionprl.getHttpemp() != null) {
			where.append(" AND t1.HTTPEMP = ?");
			params.add(comunicacionprl.getHttpemp());
		}
		if (comunicacionprl != null && comunicacionprl.getTrbtot() != null) {
			where.append(" AND t1.TRBTOT = ?");
			params.add(comunicacionprl.getTrbtot());
		}
		if (comunicacionprl != null && comunicacionprl.getObserv() != null) {
			where.append(" AND t1.OBSERV = ?");
			params.add(comunicacionprl.getObserv());
		}
		if (comunicacionprl != null && comunicacionprl.getCodctr() != null) {
			where.append(" AND t1.CODCTR = ?");
			params.add(comunicacionprl.getCodctr());
		}
		if (comunicacionprl != null && comunicacionprl.getFecalt() != null) {
			where.append(" AND t1.FECALT = ?");
			params.add(comunicacionprl.getFecalt());
		}
		if (comunicacionprl != null && comunicacionprl.getUsualt() != null) {
			where.append(" AND t1.USUALT = ?");
			params.add(comunicacionprl.getUsualt());
		}
		if (comunicacionprl != null && comunicacionprl.getFecmod() != null) {
			where.append(" AND t1.FECMOD = ?");
			params.add(comunicacionprl.getFecmod());
		}
		if (comunicacionprl != null && comunicacionprl.getUsumod() != null) {
			where.append(" AND t1.USUMOD = ?");
			params.add(comunicacionprl.getUsumod());
		}
		if (comunicacionprl != null && comunicacionprl.getDescemp() != null) {
			where.append(" AND t1.DESCEMP = ?");
			params.add(comunicacionprl.getDescemp());
		}
		if (comunicacionprl != null && comunicacionprl.getDoccorrecta() != null) {
			where.append(" AND t1.DOCCORRECTA = ?");
			params.add(comunicacionprl.getDoccorrecta());
		}
		if (comunicacionprl != null && comunicacionprl.getEstado() != null) {
			where.append(" AND t1.ESTADO = ?");
			params.add(comunicacionprl.getEstado());
		}
		if (comunicacionprl != null && comunicacionprl.getForpre() != null) {
			where.append(" AND t1.FORPRE = ?");
			params.add(comunicacionprl.getForpre());
		}
		if (comunicacionprl != null && comunicacionprl.getCnaeemp() != null) {
			where.append(" AND t1.CNAEEMP = ?");
			params.add(comunicacionprl.getCnaeemp());
		}
		if (comunicacionprl != null && comunicacionprl.getIndanx() != null) {
			where.append(" AND t1.INDANX = ?");
			params.add(comunicacionprl.getIndanx());
		}
		if (comunicacionprl != null && comunicacionprl.getApdoanx() != null) {
			where.append(" AND t1.APDOANX = ?");
			params.add(comunicacionprl.getApdoanx());
		}
		if (comunicacionprl != null && comunicacionprl.getPrvctr() != null) {
			where.append(" AND t1.PRVCTR = ?");
			params.add(comunicacionprl.getPrvctr());
		}
		if (comunicacionprl != null && comunicacionprl.getMunctr() != null) {
			where.append(" AND t1.MUNCTR = ?");
			params.add(comunicacionprl.getMunctr());
		}
		if (comunicacionprl != null && comunicacionprl.getLocctr() != null) {
			where.append(" AND t1.LOCCTR = ?");
			params.add(comunicacionprl.getLocctr());
		}
		if (comunicacionprl != null && comunicacionprl.getDirctr() != null) {
			where.append(" AND t1.DIRCTR = ?");
			params.add(comunicacionprl.getDirctr());
		}
		if (comunicacionprl != null && comunicacionprl.getCpoctr() != null) {
			where.append(" AND t1.CPOCTR = ?");
			params.add(comunicacionprl.getCpoctr());
		}
		if (comunicacionprl != null && comunicacionprl.getTipmpr1() != null) {
			where.append(" AND t1.TIPMPR1 = ?");
			params.add(comunicacionprl.getTipmpr1());
		}
		if (comunicacionprl != null && comunicacionprl.getNommpr1() != null) {
			where.append(" AND t1.NOMMPR1 = ?");
			params.add(comunicacionprl.getNommpr1());
		}
		if (comunicacionprl != null && comunicacionprl.getTipmpr2() != null) {
			where.append(" AND t1.TIPMPR2 = ?");
			params.add(comunicacionprl.getTipmpr2());
		}
		if (comunicacionprl != null && comunicacionprl.getNommpr2() != null) {
			where.append(" AND t1.NOMMPR2 = ?");
			params.add(comunicacionprl.getNommpr2());
		}
		if (comunicacionprl != null && comunicacionprl.getTopseg1() != null) {
			where.append(" AND t1.TOPSEG1 = ?");
			params.add(comunicacionprl.getTopseg1());
		}
		if (comunicacionprl != null && comunicacionprl.getTopseg2() != null) {
			where.append(" AND t1.TOPSEG2 = ?");
			params.add(comunicacionprl.getTopseg2());
		}
		if (comunicacionprl != null && comunicacionprl.getTophig1() != null) {
			where.append(" AND t1.TOPHIG1 = ?");
			params.add(comunicacionprl.getTophig1());
		}
		if (comunicacionprl != null && comunicacionprl.getTophig2() != null) {
			where.append(" AND t1.TOPHIG2 = ?");
			params.add(comunicacionprl.getTophig2());
		}
		if (comunicacionprl != null && comunicacionprl.getToperg1() != null) {
			where.append(" AND t1.TOPERG1 = ?");
			params.add(comunicacionprl.getToperg1());
		}
		if (comunicacionprl != null && comunicacionprl.getToperg2() != null) {
			where.append(" AND t1.TOPERG2 = ?");
			params.add(comunicacionprl.getToperg2());
		}
		if (comunicacionprl != null && comunicacionprl.getTopvig1() != null) {
			where.append(" AND t1.TOPVIG1 = ?");
			params.add(comunicacionprl.getTopvig1());
		}
		if (comunicacionprl != null && comunicacionprl.getTopvig2() != null) {
			where.append(" AND t1.TOPVIG2 = ?");
			params.add(comunicacionprl.getTopvig2());
		}
		if (comunicacionprl != null && comunicacionprl.getTiprie1() != null) {
			where.append(" AND t1.TIPRIE1 = ?");
			params.add(comunicacionprl.getTiprie1());
		}
		if (comunicacionprl != null && comunicacionprl.getNomrie1() != null) {
			where.append(" AND t1.NOMRIE1 = ?");
			params.add(comunicacionprl.getNomrie1());
		}
		if (comunicacionprl != null && comunicacionprl.getTiprie2() != null) {
			where.append(" AND t1.TIPRIE2 = ?");
			params.add(comunicacionprl.getTiprie2());
		}
		if (comunicacionprl != null && comunicacionprl.getNomrie2() != null) {
			where.append(" AND t1.NOMRIE2 = ?");
			params.add(comunicacionprl.getNomrie2());
		}
		if (comunicacionprl != null && comunicacionprl.getIndaud() != null) {
			where.append(" AND t1.INDAUD = ?");
			params.add(comunicacionprl.getIndaud());
		}
		if (comunicacionprl != null && comunicacionprl.getFecaud() != null) {
			where.append(" AND t1.FECAUD = ?");
			params.add(comunicacionprl.getFecaud());
		}
		if (comunicacionprl != null && comunicacionprl.getEmpaud() != null) {
			where.append(" AND t1.EMPAUD = ?");
			params.add(comunicacionprl.getEmpaud());
		}
		if (comunicacionprl != null && comunicacionprl.getDesccen() != null) {
			where.append(" AND t1.DESCCEN = ?");
			params.add(comunicacionprl.getDesccen());
		}
		if (comunicacionprl != null && comunicacionprl.getCodempaud() != null) {
			where.append(" AND t1.CODEMPAUD = ?");
			params.add(comunicacionprl.getCodempaud());
		}
		if (comunicacionprl != null && comunicacionprl.getCodprev1() != null) {
			where.append(" AND t1.CODPREV1 = ?");
			params.add(comunicacionprl.getCodprev1());
		}
		if (comunicacionprl != null && comunicacionprl.getCodprev2() != null) {
			where.append(" AND t1.CODPREV2 = ?");
			params.add(comunicacionprl.getCodprev2());
		}
		if (comunicacionprl != null && comunicacionprl.getCnaeemp93() != null) {
			where.append(" AND t1.CNAEEMP93 = ?");
			params.add(comunicacionprl.getCnaeemp93());
		}
		if (comunicacionprl != null && comunicacionprl.getClasctr() != null) {
			where.append(" AND t1.CLASCTR = ?");
			params.add(comunicacionprl.getClasctr());
		}
		if (comunicacionprl != null && comunicacionprl.getDeclar() != null) {
			where.append(" AND t1.DECLAR = ?");
			params.add(comunicacionprl.getDeclar());
		}
		if (comunicacionprl != null && comunicacionprl.getCardec() != null) {
			where.append(" AND t1.CARDEC = ?");
			params.add(comunicacionprl.getCardec());
		}
		if (comunicacionprl != null && comunicacionprl.getFecevr() != null) {
			where.append(" AND t1.FECEVR = ?");
			params.add(comunicacionprl.getFecevr());
		}
		if (comunicacionprl != null && comunicacionprl.getDesrie() != null) {
			where.append(" AND t1.DESRIE = ?");
			params.add(comunicacionprl.getDesrie());
		}
		if (comunicacionprl != null && comunicacionprl.getDesact() != null) {
			where.append(" AND t1.DESACT = ?");
			params.add(comunicacionprl.getDesact());
		}
		if (comunicacionprl != null && comunicacionprl.getNueva() != null) {
			where.append(" AND t1.NUEVA = ?");
			params.add(comunicacionprl.getNueva());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the ComunicacionPrl entity.
	 * 
	 * comunicacionprl ComunicacionPrl Bean with the criteria values to filter
	 * by. startsWith Boolean Map created with two keys key query stores the sql
	 * query syntax key params stores the parameter values to be used in the
	 * condition sentence.
	 * 
	 * @param comunicacionprl
	 *            the comunicacionprl
	 * @param startsWith
	 *            the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(
			ComunicacionPrl comunicacionprl, Boolean startsWith) {

		String mascara = Utilities.getInstance().getDateMask();

		StringBuilder where = new StringBuilder(
				ComunicacionPrlDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (comunicacionprl != null && comunicacionprl.getTipoos() != null) {
			where.append(" AND UPPER(t1.TIPOOS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionprl.getTipoos().toUpperCase() + "%");
			} else {
				params.add("%" + comunicacionprl.getTipoos().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TIPOOS IS NOT NULL");
		}
		if (comunicacionprl != null
				&& comunicacionprl.getEstadoComunicacion() != null
				&& !comunicacionprl.getEstadoComunicacion().equals(
						Constantes.VALUE_TODAS)) {

			where.append(" AND t1.ESTADO = ? ");
			params.add(comunicacionprl.getEstadoComunicacion());

		}
		if (comunicacionprl != null && comunicacionprl.getTeros() != null) {
			where.append(" AND UPPER(t1.TEROS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionprl.getTeros().toUpperCase() + "%");
			} else {
				params.add("%" + comunicacionprl.getTeros().toUpperCase() + "%");
			}
			where.append(" AND t1.TEROS IS NOT NULL");
		}
		if (comunicacionprl != null && comunicacionprl.getAnoos() != null) {
			where.append(" AND UPPER(t1.ANOOS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionprl.getAnoos().toUpperCase() + "%");
			} else {
				params.add("%" + comunicacionprl.getAnoos().toUpperCase() + "%");
			}
			where.append(" AND t1.ANOOS IS NOT NULL");
		}
		if (comunicacionprl != null && comunicacionprl.getNumos() != null) {
			where.append(" AND t1.NUMOS = ?");
			params.add(comunicacionprl.getNumos());
		}
		if (comunicacionprl != null && comunicacionprl.getNumExpDesde() != null) {
			where.append(" AND t1.NUMOS >= ?");
			params.add(comunicacionprl.getNumExpDesde());
		}
		if (comunicacionprl != null && comunicacionprl.getNumExpHasta() != null) {
			where.append(" AND t1.NUMOS <= ?");
			params.add(comunicacionprl.getNumExpHasta());
		}

		if (comunicacionprl != null && comunicacionprl.getFecpre() != null) {
			where.append(" AND t1.FECPRE = ?");
			params.add(comunicacionprl.getFecpre());
		}
		if (comunicacionprl != null && comunicacionprl.getFecpreDesde() != null) {
			where.append(" AND TRUNC(t1.FECPRE) >= trunc(to_date(?, ?)) ");
			params.add(comunicacionprl.getFecpreDesdeStr());
			params.add(mascara);
		}
		if (comunicacionprl != null && comunicacionprl.getFecpreHasta() != null) {
			where.append(" AND TRUNC(t1.FECPRE) <= trunc(to_date(?, ?)) ");
			params.add(comunicacionprl.getFecpreHastaStr());
			params.add(mascara);
		}

		if (comunicacionprl != null && comunicacionprl.getFecier() != null) {
			where.append(" AND t1.FECIER = ?");
			params.add(comunicacionprl.getFecier());
		}

		if (comunicacionprl != null
				&& comunicacionprl.getTareasPendientes() != null) {

			if ("OS2".equalsIgnoreCase(comunicacionprl.getTipoos())) {
				where.append(" AND EXISTS(SELECT '1' FROM VTAREAS_TRAMITES_OS2 where ESTADO_093='0' and TIPO_090='S' AND NUM_OS2_092=t1.numos AND TERRIT_OS2_092=t1.teros AND ANO_OS2_092=t1.anoos ");

			} else {
				where.append(" AND EXISTS(SELECT '1' FROM VTAREAS_TRAMITES_OS3 where ESTADO_096='0' and TIPO_090='S' AND NUM_OS3_095=t1.numos AND TERRIT_OS3_095=t1.teros AND ANO_OS3_095=t1.anoos ");

			}

			if (!comunicacionprl.getTareasPendientes().equals("all")) {
				where.append(" and task_id_090= ? ");
				params.add(comunicacionprl.getTareasPendientes());
			}

			where.append(" )");

		}

		/*
		 * if (comunicacionprl != null && comunicacionprl.getTerape() != null )
		 * { where.append(" AND UPPER(t1.TERAPE) like ? ESCAPE  '\\'"); if
		 * (startsWith){ params.add(comunicacionprl.getTerape().toUpperCase()
		 * +"%"); }else{
		 * params.add("%"+comunicacionprl.getTerape().toUpperCase() +"%"); }
		 * where.append(" AND t1.TERAPE IS NOT NULL"); } if (comunicacionprl !=
		 * null && comunicacionprl.getAnoape() != null ) { where.append(
		 * " AND UPPER(t1.ANOAPE) like ? ESCAPE  '\\'"); if (startsWith){
		 * params.add(comunicacionprl.getAnoape().toUpperCase() +"%"); }else{
		 * params.add("%"+comunicacionprl.getAnoape().toUpperCase() +"%"); }
		 * where.append(" AND t1.ANOAPE IS NOT NULL"); } if (comunicacionprl !=
		 * null && comunicacionprl.getNumape() != null ) { where.append(
		 * " AND t1.NUMAPE = ?"); params.add(comunicacionprl.getNumape()); }
		 */
		if (comunicacionprl != null && comunicacionprl.getTipdoc() != null) {
			where.append(" AND UPPER(t1.TIPDOC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionprl.getTipdoc().toUpperCase() + "%");
			} else {
				params.add("%" + comunicacionprl.getTipdoc().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TIPDOC IS NOT NULL");
		}
		if (comunicacionprl != null && comunicacionprl.getNumdoc() != null) {
			where.append(" AND UPPER(t1.NUMDOC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionprl.getNumdoc().toUpperCase() + "%");
			} else {
				params.add("%" + comunicacionprl.getNumdoc().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NUMDOC IS NOT NULL");
		}

		// nombre empresa
		if (comunicacionprl != null && comunicacionprl.getNomemp() != null) {
			where.append(" AND UPPER(translate(t1.NOMEMP, 'áéíóúÁÉÍÓÚ', 'aeiouAEIOU')) like '%'||UPPER(translate(?, 'áéíóúÁÉÍÓÚ', 'aeiouAEIOU'))||'%' ESCAPE  '\\'");
			params.add(comunicacionprl.getNomemp().toUpperCase());

			where.append(" AND t1.NOMEMP IS NOT NULL");
		}

		/*
		 * if (comunicacionprl != null && comunicacionprl.getPaisemp() != null )
		 * { where.append(" AND UPPER(t1.PAISEMP) like ? ESCAPE  '\\'"); if
		 * (startsWith){ params.add(comunicacionprl.getPaisemp().toUpperCase()
		 * +"%"); }else{
		 * params.add("%"+comunicacionprl.getPaisemp().toUpperCase() +"%"); }
		 * where.append(" AND t1.PAISEMP IS NOT NULL"); } if (comunicacionprl !=
		 * null && comunicacionprl.getPrvemp() != null ) { where.append(
		 * " AND UPPER(t1.PRVEMP) like ? ESCAPE  '\\'"); if (startsWith){
		 * params.add(comunicacionprl.getPrvemp().toUpperCase() +"%"); }else{
		 * params.add("%"+comunicacionprl.getPrvemp().toUpperCase() +"%"); }
		 * where.append(" AND t1.PRVEMP IS NOT NULL"); } if (comunicacionprl !=
		 * null && comunicacionprl.getMunemp() != null ) { where.append(
		 * " AND UPPER(t1.MUNEMP) like ? ESCAPE  '\\'"); if (startsWith){
		 * params.add(comunicacionprl.getMunemp().toUpperCase() +"%"); }else{
		 * params.add("%"+comunicacionprl.getMunemp().toUpperCase() +"%"); }
		 * where.append(" AND t1.MUNEMP IS NOT NULL"); } if (comunicacionprl !=
		 * null && comunicacionprl.getDmunemp() != null ) { where.append(
		 * " AND UPPER(t1.DMUNEMP) like ? ESCAPE  '\\'"); if (startsWith){
		 * params.add(comunicacionprl.getDmunemp().toUpperCase() +"%"); }else{
		 * params.add("%"+comunicacionprl.getDmunemp().toUpperCase() +"%"); }
		 * where.append(" AND t1.DMUNEMP IS NOT NULL"); } if (comunicacionprl !=
		 * null && comunicacionprl.getDiremp() != null ) { where.append(
		 * " AND UPPER(t1.DIREMP) like ? ESCAPE  '\\'"); if (startsWith){
		 * params.add(comunicacionprl.getDiremp().toUpperCase() +"%"); }else{
		 * params.add("%"+comunicacionprl.getDiremp().toUpperCase() +"%"); }
		 * where.append(" AND t1.DIREMP IS NOT NULL"); } if (comunicacionprl !=
		 * null && comunicacionprl.getCpoemp() != null ) { where.append(
		 * " AND UPPER(t1.CPOEMP) like ? ESCAPE  '\\'"); if (startsWith){
		 * params.add(comunicacionprl.getCpoemp().toUpperCase() +"%"); }else{
		 * params.add("%"+comunicacionprl.getCpoemp().toUpperCase() +"%"); }
		 * where.append(" AND t1.CPOEMP IS NOT NULL"); } if (comunicacionprl !=
		 * null && comunicacionprl.getTlfemp() != null ) { where.append(
		 * " AND UPPER(t1.TLFEMP) like ? ESCAPE  '\\'"); if (startsWith){
		 * params.add(comunicacionprl.getTlfemp().toUpperCase() +"%"); }else{
		 * params.add("%"+comunicacionprl.getTlfemp().toUpperCase() +"%"); }
		 * where.append(" AND t1.TLFEMP IS NOT NULL"); } if (comunicacionprl !=
		 * null && comunicacionprl.getFaxemp() != null ) { where.append(
		 * " AND UPPER(t1.FAXEMP) like ? ESCAPE  '\\'"); if (startsWith){
		 * params.add(comunicacionprl.getFaxemp().toUpperCase() +"%"); }else{
		 * params.add("%"+comunicacionprl.getFaxemp().toUpperCase() +"%"); }
		 * where.append(" AND t1.FAXEMP IS NOT NULL"); } if (comunicacionprl !=
		 * null && comunicacionprl.getEmaemp() != null ) { where.append(
		 * " AND UPPER(t1.EMAEMP) like ? ESCAPE  '\\'"); if (startsWith){
		 * params.add(comunicacionprl.getEmaemp().toUpperCase() +"%"); }else{
		 * params.add("%"+comunicacionprl.getEmaemp().toUpperCase() +"%"); }
		 * where.append(" AND t1.EMAEMP IS NOT NULL"); } if (comunicacionprl !=
		 * null && comunicacionprl.getHttpemp() != null ) { where.append(
		 * " AND UPPER(t1.HTTPEMP) like ? ESCAPE  '\\'"); if (startsWith){
		 * params.add(comunicacionprl.getHttpemp().toUpperCase() +"%"); }else{
		 * params.add("%"+comunicacionprl.getHttpemp().toUpperCase() +"%"); }
		 * where.append(" AND t1.HTTPEMP IS NOT NULL"); } if (comunicacionprl !=
		 * null && comunicacionprl.getTrbtot() != null ) { where.append(
		 * " AND t1.TRBTOT = ?"); params.add(comunicacionprl.getTrbtot()); } if
		 * (comunicacionprl != null && comunicacionprl.getObserv() != null ) {
		 * where.append(" AND UPPER(t1.OBSERV) like ? ESCAPE  '\\'"); if
		 * (startsWith){ params.add(comunicacionprl.getObserv().toUpperCase()
		 * +"%"); }else{
		 * params.add("%"+comunicacionprl.getObserv().toUpperCase() +"%"); }
		 * where.append(" AND t1.OBSERV IS NOT NULL"); } if (comunicacionprl !=
		 * null && comunicacionprl.getCodctr() != null ) { where.append(
		 * " AND t1.CODCTR = ?"); params.add(comunicacionprl.getCodctr()); } if
		 * (comunicacionprl != null && comunicacionprl.getFecalt() != null ) {
		 * where.append(" AND t1.FECALT = ?");
		 * params.add(comunicacionprl.getFecalt()); } if (comunicacionprl !=
		 * null && comunicacionprl.getUsualt() != null ) { where.append(
		 * " AND UPPER(t1.USUALT) like ? ESCAPE  '\\'"); if (startsWith){
		 * params.add(comunicacionprl.getUsualt().toUpperCase() +"%"); }else{
		 * params.add("%"+comunicacionprl.getUsualt().toUpperCase() +"%"); }
		 * where.append(" AND t1.USUALT IS NOT NULL"); } if (comunicacionprl !=
		 * null && comunicacionprl.getFecmod() != null ) { where.append(
		 * " AND t1.FECMOD = ?"); params.add(comunicacionprl.getFecmod()); } if
		 * (comunicacionprl != null && comunicacionprl.getUsumod() != null ) {
		 * where.append(" AND UPPER(t1.USUMOD) like ? ESCAPE  '\\'"); if
		 * (startsWith){ params.add(comunicacionprl.getUsumod().toUpperCase()
		 * +"%"); }else{
		 * params.add("%"+comunicacionprl.getUsumod().toUpperCase() +"%"); }
		 * where.append(" AND t1.USUMOD IS NOT NULL"); } if (comunicacionprl !=
		 * null && comunicacionprl.getDescemp() != null ) { where.append(
		 * " AND UPPER(t1.DESCEMP) like ? ESCAPE  '\\'"); if (startsWith){
		 * params.add(comunicacionprl.getDescemp().toUpperCase() +"%"); }else{
		 * params.add("%"+comunicacionprl.getDescemp().toUpperCase() +"%"); }
		 * where.append(" AND t1.DESCEMP IS NOT NULL"); } if (comunicacionprl !=
		 * null && comunicacionprl.getDoccorrecta() != null ) { where.append(
		 * " AND UPPER(t1.DOCCORRECTA) like ? ESCAPE  '\\'"); if (startsWith){
		 * params.add(comunicacionprl.getDoccorrecta().toUpperCase() +"%");
		 * }else{ params.add("%"+comunicacionprl.getDoccorrecta().toUpperCase()
		 * +"%"); } where.append(" AND t1.DOCCORRECTA IS NOT NULL"); } if
		 * (comunicacionprl != null && comunicacionprl.getEstado() != null ) {
		 * where.append(" AND UPPER(t1.ESTADO) like ? ESCAPE  '\\'"); if
		 * (startsWith){ params.add(comunicacionprl.getEstado().toUpperCase()
		 * +"%"); }else{
		 * params.add("%"+comunicacionprl.getEstado().toUpperCase() +"%"); }
		 * where.append(" AND t1.ESTADO IS NOT NULL"); }
		 */
		if (comunicacionprl != null && comunicacionprl.getForpre() != null) {
			where.append(" AND UPPER(t1.FORPRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionprl.getForpre().toUpperCase() + "%");
			} else {
				params.add("%" + comunicacionprl.getForpre().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.FORPRE IS NOT NULL");
		}
		/*
		 * if (comunicacionprl != null && comunicacionprl.getCnaeemp() != null )
		 * { where.append(" AND UPPER(t1.CNAEEMP) like ? ESCAPE  '\\'"); if
		 * (startsWith){ params.add(comunicacionprl.getCnaeemp().toUpperCase()
		 * +"%"); }else{
		 * params.add("%"+comunicacionprl.getCnaeemp().toUpperCase() +"%"); }
		 * where.append(" AND t1.CNAEEMP IS NOT NULL"); } if (comunicacionprl !=
		 * null && comunicacionprl.getIndanx() != null ) { where.append(
		 * " AND UPPER(t1.INDANX) like ? ESCAPE  '\\'"); if (startsWith){
		 * params.add(comunicacionprl.getIndanx().toUpperCase() +"%"); }else{
		 * params.add("%"+comunicacionprl.getIndanx().toUpperCase() +"%"); }
		 * where.append(" AND t1.INDANX IS NOT NULL"); } if (comunicacionprl !=
		 * null && comunicacionprl.getApdoanx() != null ) { where.append(
		 * " AND UPPER(t1.APDOANX) like ? ESCAPE  '\\'"); if (startsWith){
		 * params.add(comunicacionprl.getApdoanx().toUpperCase() +"%"); }else{
		 * params.add("%"+comunicacionprl.getApdoanx().toUpperCase() +"%"); }
		 * where.append(" AND t1.APDOANX IS NOT NULL"); }
		 */

		if (comunicacionprl != null && comunicacionprl.getPrvctr() != null) {
			if (comunicacionprl.getTipoos() != null
					&& comunicacionprl.getTipoos().equals(Constantes.OS2)) {
				where.append(" AND UPPER(t1.PRVCTR) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(comunicacionprl.getPrvctr().toUpperCase() + "%");
				} else {
					params.add("%" + comunicacionprl.getPrvctr().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.PRVCTR IS NOT NULL");
			} else if (comunicacionprl.getTipoos() == null) {
				where.append(" AND ((UPPER(t1.PRVCTR) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(comunicacionprl.getPrvctr().toUpperCase() + "%");
				} else {
					params.add("%" + comunicacionprl.getPrvctr().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.PRVCTR IS NOT NULL)");
				where.append(" OR (t1.TIPOOS like 'OS3' AND t1.PRVCTR IS NULL))");
			}
		}

		if (comunicacionprl != null && comunicacionprl.getMunctr() != null) {
			if (comunicacionprl.getTipoos() != null
					&& comunicacionprl.getTipoos().equals(Constantes.OS2)) {
				where.append(" AND UPPER(t1.MUNCTR) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(comunicacionprl.getMunctr().toUpperCase() + "%");
				} else {
					params.add("%" + comunicacionprl.getMunctr().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.MUNCTR IS NOT NULL");
			} else if (comunicacionprl.getTipoos() == null) {
				where.append(" AND ((UPPER(t1.MUNCTR) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(comunicacionprl.getMunctr().toUpperCase() + "%");
				} else {
					params.add("%" + comunicacionprl.getMunctr().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.MUNCTR IS NOT NULL)");
				where.append(" OR (t1.TIPOOS like 'OS3' AND t1.MUNCTR IS NULL))");
			}
		}
		/*
		 * if (comunicacionprl != null && comunicacionprl.getLocctr() != null )
		 * { where.append(" AND UPPER(t1.LOCCTR) like ? ESCAPE  '\\'"); if
		 * (startsWith){ params.add(comunicacionprl.getLocctr().toUpperCase()
		 * +"%"); }else{
		 * params.add("%"+comunicacionprl.getLocctr().toUpperCase() +"%"); }
		 * where.append(" AND t1.LOCCTR IS NOT NULL"); } if (comunicacionprl !=
		 * null && comunicacionprl.getDirctr() != null ) { where.append(
		 * " AND UPPER(t1.DIRCTR) like ? ESCAPE  '\\'"); if (startsWith){
		 * params.add(comunicacionprl.getDirctr().toUpperCase() +"%"); }else{
		 * params.add("%"+comunicacionprl.getDirctr().toUpperCase() +"%"); }
		 * where.append(" AND t1.DIRCTR IS NOT NULL"); } if (comunicacionprl !=
		 * null && comunicacionprl.getCpoctr() != null ) { where.append(
		 * " AND UPPER(t1.CPOCTR) like ? ESCAPE  '\\'"); if (startsWith){
		 * params.add(comunicacionprl.getCpoctr().toUpperCase() +"%"); }else{
		 * params.add("%"+comunicacionprl.getCpoctr().toUpperCase() +"%"); }
		 * where.append(" AND t1.CPOCTR IS NOT NULL"); }
		 */
		/*
		 * if (comunicacionprl != null && comunicacionprl.getTipmpr1() != null )
		 * { where.append(" AND UPPER(t1.TIPMPR1) like ? ESCAPE  '\\'"); if
		 * (startsWith){ params.add(comunicacionprl.getTipmpr1().toUpperCase()
		 * +"%"); }else{
		 * params.add("%"+comunicacionprl.getTipmpr1().toUpperCase() +"%"); }
		 * where.append(" AND t1.TIPMPR1 IS NOT NULL"); } if (comunicacionprl !=
		 * null && comunicacionprl.getNommpr1() != null ) { where.append(
		 * " AND UPPER(t1.NOMMPR1) like ? ESCAPE  '\\'"); if (startsWith){
		 * params.add(comunicacionprl.getNommpr1().toUpperCase() +"%"); }else{
		 * params.add("%"+comunicacionprl.getNommpr1().toUpperCase() +"%"); }
		 * where.append(" AND t1.NOMMPR1 IS NOT NULL"); } if (comunicacionprl !=
		 * null && comunicacionprl.getTipmpr2() != null ) { where.append(
		 * " AND UPPER(t1.TIPMPR2) like ? ESCAPE  '\\'"); if (startsWith){
		 * params.add(comunicacionprl.getTipmpr2().toUpperCase() +"%"); }else{
		 * params.add("%"+comunicacionprl.getTipmpr2().toUpperCase() +"%"); }
		 * where.append(" AND t1.TIPMPR2 IS NOT NULL"); } if (comunicacionprl !=
		 * null && comunicacionprl.getNommpr2() != null ) { where.append(
		 * " AND UPPER(t1.NOMMPR2) like ? ESCAPE  '\\'"); if (startsWith){
		 * params.add(comunicacionprl.getNommpr2().toUpperCase() +"%"); }else{
		 * params.add("%"+comunicacionprl.getNommpr2().toUpperCase() +"%"); }
		 * where.append(" AND t1.NOMMPR2 IS NOT NULL"); }
		 */
		if (comunicacionprl != null && comunicacionprl.getTipmpr() != null) {
			if (comunicacionprl.getTipoos() != null
					&& comunicacionprl.getTipoos().equals(Constantes.OS2)) {
				where.append(" AND ((UPPER(t1.TIPMPR1) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(comunicacionprl.getTipmpr().toUpperCase() + "%");
				} else {
					params.add("%" + comunicacionprl.getTipmpr().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.TIPMPR1 IS NOT NULL)");

				where.append(" OR (UPPER(t1.TIPMPR2) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(comunicacionprl.getTipmpr().toUpperCase() + "%");
				} else {
					params.add("%" + comunicacionprl.getTipmpr().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.TIPMPR2 IS NOT NULL))");
			} else if (comunicacionprl.getTipoos() == null) {
				where.append(" AND (((UPPER(t1.TIPMPR1) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(comunicacionprl.getTipmpr().toUpperCase() + "%");
				} else {
					params.add("%" + comunicacionprl.getTipmpr().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.TIPMPR1 IS NOT NULL)");

				where.append(" OR (UPPER(t1.TIPMPR2) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(comunicacionprl.getTipmpr().toUpperCase() + "%");
				} else {
					params.add("%" + comunicacionprl.getTipmpr().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.TIPMPR2 IS NOT NULL))");
				where.append(" OR (t1.TIPOOS like 'OS3' AND t1.TIPMPR1 IS NULL AND t1.TIPMPR2 IS NULL))");
			}
		}
		/*
		 * if (comunicacionprl != null && comunicacionprl.getTopseg1() != null )
		 * { where.append(" AND UPPER(t1.TOPSEG1) like ? ESCAPE  '\\'"); if
		 * (startsWith){ params.add(comunicacionprl.getTopseg1().toUpperCase()
		 * +"%"); }else{
		 * params.add("%"+comunicacionprl.getTopseg1().toUpperCase() +"%"); }
		 * where.append(" AND t1.TOPSEG1 IS NOT NULL"); } if (comunicacionprl !=
		 * null && comunicacionprl.getTopseg2() != null ) { where.append(
		 * " AND UPPER(t1.TOPSEG2) like ? ESCAPE  '\\'"); if (startsWith){
		 * params.add(comunicacionprl.getTopseg2().toUpperCase() +"%"); }else{
		 * params.add("%"+comunicacionprl.getTopseg2().toUpperCase() +"%"); }
		 * where.append(" AND t1.TOPSEG2 IS NOT NULL"); } if (comunicacionprl !=
		 * null && comunicacionprl.getTophig1() != null ) { where.append(
		 * " AND UPPER(t1.TOPHIG1) like ? ESCAPE  '\\'"); if (startsWith){
		 * params.add(comunicacionprl.getTophig1().toUpperCase() +"%"); }else{
		 * params.add("%"+comunicacionprl.getTophig1().toUpperCase() +"%"); }
		 * where.append(" AND t1.TOPHIG1 IS NOT NULL"); } if (comunicacionprl !=
		 * null && comunicacionprl.getTophig2() != null ) { where.append(
		 * " AND UPPER(t1.TOPHIG2) like ? ESCAPE  '\\'"); if (startsWith){
		 * params.add(comunicacionprl.getTophig2().toUpperCase() +"%"); }else{
		 * params.add("%"+comunicacionprl.getTophig2().toUpperCase() +"%"); }
		 * where.append(" AND t1.TOPHIG2 IS NOT NULL"); } if (comunicacionprl !=
		 * null && comunicacionprl.getToperg1() != null ) { where.append(
		 * " AND UPPER(t1.TOPERG1) like ? ESCAPE  '\\'"); if (startsWith){
		 * params.add(comunicacionprl.getToperg1().toUpperCase() +"%"); }else{
		 * params.add("%"+comunicacionprl.getToperg1().toUpperCase() +"%"); }
		 * where.append(" AND t1.TOPERG1 IS NOT NULL"); } if (comunicacionprl !=
		 * null && comunicacionprl.getToperg2() != null ) { where.append(
		 * " AND UPPER(t1.TOPERG2) like ? ESCAPE  '\\'"); if (startsWith){
		 * params.add(comunicacionprl.getToperg2().toUpperCase() +"%"); }else{
		 * params.add("%"+comunicacionprl.getToperg2().toUpperCase() +"%"); }
		 * where.append(" AND t1.TOPERG2 IS NOT NULL"); } if (comunicacionprl !=
		 * null && comunicacionprl.getTopvig1() != null ) { where.append(
		 * " AND UPPER(t1.TOPVIG1) like ? ESCAPE  '\\'"); if (startsWith){
		 * params.add(comunicacionprl.getTopvig1().toUpperCase() +"%"); }else{
		 * params.add("%"+comunicacionprl.getTopvig1().toUpperCase() +"%"); }
		 * where.append(" AND t1.TOPVIG1 IS NOT NULL"); } if (comunicacionprl !=
		 * null && comunicacionprl.getTopvig2() != null ) { where.append(
		 * " AND UPPER(t1.TOPVIG2) like ? ESCAPE  '\\'"); if (startsWith){
		 * params.add(comunicacionprl.getTopvig2().toUpperCase() +"%"); }else{
		 * params.add("%"+comunicacionprl.getTopvig2().toUpperCase() +"%"); }
		 * where.append(" AND t1.TOPVIG2 IS NOT NULL"); } if (comunicacionprl !=
		 * null && comunicacionprl.getTiprie1() != null ) { where.append(
		 * " AND UPPER(t1.TIPRIE1) like ? ESCAPE  '\\'"); if (startsWith){
		 * params.add(comunicacionprl.getTiprie1().toUpperCase() +"%"); }else{
		 * params.add("%"+comunicacionprl.getTiprie1().toUpperCase() +"%"); }
		 * where.append(" AND t1.TIPRIE1 IS NOT NULL"); } if (comunicacionprl !=
		 * null && comunicacionprl.getNomrie1() != null ) { where.append(
		 * " AND UPPER(t1.NOMRIE1) like ? ESCAPE  '\\'"); if (startsWith){
		 * params.add(comunicacionprl.getNomrie1().toUpperCase() +"%"); }else{
		 * params.add("%"+comunicacionprl.getNomrie1().toUpperCase() +"%"); }
		 * where.append(" AND t1.NOMRIE1 IS NOT NULL"); } if (comunicacionprl !=
		 * null && comunicacionprl.getTiprie2() != null ) { where.append(
		 * " AND UPPER(t1.TIPRIE2) like ? ESCAPE  '\\'"); if (startsWith){
		 * params.add(comunicacionprl.getTiprie2().toUpperCase() +"%"); }else{
		 * params.add("%"+comunicacionprl.getTiprie2().toUpperCase() +"%"); }
		 * where.append(" AND t1.TIPRIE2 IS NOT NULL"); } if (comunicacionprl !=
		 * null && comunicacionprl.getNomrie2() != null ) { where.append(
		 * " AND UPPER(t1.NOMRIE2) like ? ESCAPE  '\\'"); if (startsWith){
		 * params.add(comunicacionprl.getNomrie2().toUpperCase() +"%"); }else{
		 * params.add("%"+comunicacionprl.getNomrie2().toUpperCase() +"%"); }
		 * where.append(" AND t1.NOMRIE2 IS NOT NULL"); }
		 */
		if (comunicacionprl != null && comunicacionprl.getIndaud() != null) {
			if (comunicacionprl.getTipoos() != null
					&& comunicacionprl.getTipoos().equals(Constantes.OS2)) {
				where.append(" AND UPPER(t1.INDAUD) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(comunicacionprl.getIndaud().toUpperCase() + "%");
				} else {
					params.add("%" + comunicacionprl.getIndaud().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.INDAUD IS NOT NULL");
			} else if (comunicacionprl.getTipoos() == null) {
				where.append(" AND ((UPPER(t1.INDAUD) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(comunicacionprl.getIndaud().toUpperCase() + "%");
				} else {
					params.add("%" + comunicacionprl.getIndaud().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.INDAUD IS NOT NULL)");
				where.append(" OR (t1.TIPOOS like 'OS3' AND t1.INDAUD IS NULL))");
			}
		}
		/*
		 * if (comunicacionprl != null && comunicacionprl.getFecaud() != null )
		 * { where.append(" AND t1.FECAUD = ?");
		 * params.add(comunicacionprl.getFecaud()); } if (comunicacionprl !=
		 * null && comunicacionprl.getEmpaud() != null ) { where.append(
		 * " AND UPPER(t1.EMPAUD) like ? ESCAPE  '\\'"); if (startsWith){
		 * params.add(comunicacionprl.getEmpaud().toUpperCase() +"%"); }else{
		 * params.add("%"+comunicacionprl.getEmpaud().toUpperCase() +"%"); }
		 * where.append(" AND t1.EMPAUD IS NOT NULL"); }
		 */
		/*
		 * if (comunicacionprl != null && comunicacionprl.getDesccen() != null )
		 * { where.append(" AND UPPER(t1.DESCCEN) like ? ESCAPE  '\\'"); if
		 * (startsWith){ params.add(comunicacionprl.getDesccen().toUpperCase()
		 * +"%"); }else{
		 * params.add("%"+comunicacionprl.getDesccen().toUpperCase() +"%"); }
		 * where.append(" AND t1.DESCCEN IS NOT NULL"); }
		 */
		if (comunicacionprl != null && comunicacionprl.getCodempaud() != null) {
			if (comunicacionprl.getTipoos() != null
					&& comunicacionprl.getTipoos().equals(Constantes.OS2)) {
				where.append(" AND UPPER(t1.CODEMPAUD) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(comunicacionprl.getCodempaud().toUpperCase()
							+ "%");
				} else {
					params.add("%"
							+ comunicacionprl.getCodempaud().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.CODEMPAUD IS NOT NULL");
			} else if (comunicacionprl.getTipoos() == null) {
				where.append(" AND ((UPPER(t1.CODEMPAUD) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(comunicacionprl.getCodempaud().toUpperCase()
							+ "%");
				} else {
					params.add("%"
							+ comunicacionprl.getCodempaud().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.CODEMPAUD IS NOT NULL)");
				where.append(" OR (t1.TIPOOS like 'OS3' AND t1.CODEMPAUD IS NULL))");
			}
		}
		/*
		 * if (comunicacionprl != null && comunicacionprl.getCodprev1() != null
		 * ) { where.append(" AND UPPER(t1.CODPREV1) like ? ESCAPE  '\\'"); if
		 * (startsWith){ params.add(comunicacionprl.getCodprev1().toUpperCase()
		 * +"%"); }else{
		 * params.add("%"+comunicacionprl.getCodprev1().toUpperCase() +"%"); }
		 * where.append(" AND t1.CODPREV1 IS NOT NULL"); } if (comunicacionprl
		 * != null && comunicacionprl.getCodprev2() != null ) { where.append(
		 * " AND UPPER(t1.CODPREV2) like ? ESCAPE  '\\'"); if (startsWith){
		 * params.add(comunicacionprl.getCodprev2().toUpperCase() +"%"); }else{
		 * params.add("%"+comunicacionprl.getCodprev2().toUpperCase() +"%"); }
		 * where.append(" AND t1.CODPREV2 IS NOT NULL"); }
		 */
		if (comunicacionprl != null && comunicacionprl.getCodprev() != null) {
			if (comunicacionprl.getTipoos() != null
					&& comunicacionprl.getTipoos().equals(Constantes.OS2)) {
				where.append(" AND ((UPPER(t1.CODPREV1) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(comunicacionprl.getCodprev().toUpperCase() + "%");
				} else {
					params.add("%" + comunicacionprl.getCodprev().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.CODPREV1 IS NOT NULL)");

				where.append(" OR (UPPER(t1.CODPREV2) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(comunicacionprl.getCodprev().toUpperCase() + "%");
				} else {
					params.add("%" + comunicacionprl.getCodprev().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.CODPREV2 IS NOT NULL))");
			} else if (comunicacionprl.getTipoos() == null) {
				where.append(" AND (((UPPER(t1.CODPREV1) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(comunicacionprl.getCodprev().toUpperCase() + "%");
				} else {
					params.add("%" + comunicacionprl.getCodprev().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.CODPREV1 IS NOT NULL)");

				where.append(" OR (UPPER(t1.CODPREV2) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add(comunicacionprl.getCodprev().toUpperCase() + "%");
				} else {
					params.add("%" + comunicacionprl.getCodprev().toUpperCase()
							+ "%");
				}
				where.append(" AND t1.CODPREV2 IS NOT NULL))");
				where.append(" OR (t1.TIPOOS like 'OS3' AND t1.CODPREV1 IS NULL AND t1.CODPREV2 IS NULL))");
			}
		}
		/*
		 * if (comunicacionprl != null && comunicacionprl.getCnaeemp93() != null
		 * ) { where.append(" AND UPPER(t1.CNAEEMP93) like ? ESCAPE  '\\'"); if
		 * (startsWith){ params.add(comunicacionprl.getCnaeemp93().toUpperCase()
		 * +"%"); }else{
		 * params.add("%"+comunicacionprl.getCnaeemp93().toUpperCase() +"%"); }
		 * where.append(" AND t1.CNAEEMP93 IS NOT NULL"); } if (comunicacionprl
		 * != null && comunicacionprl.getClasctr() != null ) { where.append(
		 * " AND UPPER(t1.CLASCTR) like ? ESCAPE  '\\'"); if (startsWith){
		 * params.add(comunicacionprl.getClasctr().toUpperCase() +"%"); }else{
		 * params.add("%"+comunicacionprl.getClasctr().toUpperCase() +"%"); }
		 * where.append(" AND t1.CLASCTR IS NOT NULL"); } if (comunicacionprl !=
		 * null && comunicacionprl.getDeclar() != null ) { where.append(
		 * " AND UPPER(t1.DECLAR) like ? ESCAPE  '\\'"); if (startsWith){
		 * params.add(comunicacionprl.getDeclar().toUpperCase() +"%"); }else{
		 * params.add("%"+comunicacionprl.getDeclar().toUpperCase() +"%"); }
		 * where.append(" AND t1.DECLAR IS NOT NULL"); } if (comunicacionprl !=
		 * null && comunicacionprl.getCardec() != null ) { where.append(
		 * " AND UPPER(t1.CARDEC) like ? ESCAPE  '\\'"); if (startsWith){
		 * params.add(comunicacionprl.getCardec().toUpperCase() +"%"); }else{
		 * params.add("%"+comunicacionprl.getCardec().toUpperCase() +"%"); }
		 * where.append(" AND t1.CARDEC IS NOT NULL"); } if (comunicacionprl !=
		 * null && comunicacionprl.getFecevr() != null ) { where.append(
		 * " AND t1.FECEVR = ?"); params.add(comunicacionprl.getFecevr()); } if
		 * (comunicacionprl != null && comunicacionprl.getDesrie() != null ) {
		 * where.append(" AND UPPER(t1.DESRIE) like ? ESCAPE  '\\'"); if
		 * (startsWith){ params.add(comunicacionprl.getDesrie().toUpperCase()
		 * +"%"); }else{
		 * params.add("%"+comunicacionprl.getDesrie().toUpperCase() +"%"); }
		 * where.append(" AND t1.DESRIE IS NOT NULL"); } if (comunicacionprl !=
		 * null && comunicacionprl.getDesact() != null ) { where.append(
		 * " AND UPPER(t1.DESACT) like ? ESCAPE  '\\'"); if (startsWith){
		 * params.add(comunicacionprl.getDesact().toUpperCase() +"%"); }else{
		 * params.add("%"+comunicacionprl.getDesact().toUpperCase() +"%"); }
		 * where.append(" AND t1.DESACT IS NOT NULL"); } if (comunicacionprl !=
		 * null && comunicacionprl.getNueva() != null ) { where.append(
		 * " AND UPPER(t1.NUEVA) like ? ESCAPE  '\\'"); if (startsWith){
		 * params.add(comunicacionprl.getNueva().toUpperCase() +"%"); }else{
		 * params.add("%"+comunicacionprl.getNueva().toUpperCase() +"%"); }
		 * where.append(" AND t1.NUEVA IS NOT NULL"); }
		 */

		// Si el usuario no tiene perfil de tramitador_osalan, no se muestran
		// los OS2/OS3 que estén en proceso de alta,
		// ya que en estos sólo se puede entrar en modo alta, y sólo pueden
		// hacerlo los tramitadores_osalan.
		if (comunicacionprl.isOcultarEnProcesoAlta()) {

			where.append("  AND ((t1.MIGRADO = 'N' AND t1.FOLDER_ID IS NOT NULL) OR (t1.MIGRADO = 'S')) ");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab04b56s00 entity.
	 * 
	 * ab04b56s00 Ab04b56s00 Bean with the criteria values to filter by.
	 * startsWith Boolean Map created with two keys key query stores the sql
	 * query syntax key params stores the parameter values to be used in the
	 * condition sentence.
	 * 
	 * @param ab04b56s00
	 *            the ab 04 b 56 s 00
	 * @param startsWith
	 *            the starts with
	 * @return the vista where like map etiquetas
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getVistaWhereLikeMapEtiquetas(
			ComunicacionPrl ab04b56s00, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				ComunicacionAperturaCustomDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		// territorio
		if (ab04b56s00 != null && ab04b56s00.getTeros() != null) {
			where.append(" AND UPPER(t1.TEROS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getTeros().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getTeros().toUpperCase() + "%");
			}
			where.append(" AND t1.TEROS IS NOT NULL");
		}

		// año
		if (ab04b56s00 != null && ab04b56s00.getAnoos() != null) {
			where.append(" AND UPPER(t1.ANOOS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab04b56s00.getAnoos().toUpperCase() + "%");
			} else {
				params.add("%" + ab04b56s00.getAnoos().toUpperCase() + "%");
			}
			where.append(" AND t1.ANOOS IS NOT NULL");
		}

		// num expediente
		if (ab04b56s00 != null && ab04b56s00.getNumos() != null) {
			where.append(" AND t1.NUMOS = ?");
			params.add(ab04b56s00.getNumos());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Devuelve los datos de notificacion de un expediente.
	 * 
	 * filtro ComunicacionApertura startsWith Boolean ComunicacionApertura
	 * 
	 * @param filtro
	 *            the filtro
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<ComunicacionApertura> obtenerDatosEtiquetas(
			ComunicacionPrl filtro, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				ComunicacionPrlDaoImpl.QUERY_SELECT_DATOS_ETIQUETAS);
		query.append(ComunicacionPrlDaoImpl.QUERY_FROM_DATOS_ETIQUETAS);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getVistaWhereLikeMapEtiquetas(filtro,
				startsWith);

		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t2.CANALNOTIF_066 = 1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		List<?> params = (List<?>) mapaWhere.get("params");

		return (List<ComunicacionApertura>) this.jdbcTemplate.query(
				query.toString(), this.rwMapDatosEtiquetas, params.toArray());
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Counts rows in the PORTAL table.
	 * 
	 * comunicacionPrl ComunicacionPrl Long
	 * 
	 * @param comunicacionPrl
	 *            the comunicacion prl
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findCPenLocalidadCount(ComunicacionPrl comunicacionPrl) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM PORTAL ");

		query.append(" where COD_LOCALIDAD = ? and COD_POSTAL = ? ");

		List<Object> params = new ArrayList<Object>();
		params.add(comunicacionPrl.getDatosNotificacion()
				.getDatosLocalizacion().getLocalidad().getCodLocalidad());
		params.add(comunicacionPrl.getDatosNotificacion()
				.getDatosLocalizacion().getCodpostal067());

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

}
